% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect.R
\name{detect}
\alias{detect}
\title{Suggesting values for \code{r2}}
\usage{
detect(
  X,
  y,
  heredity = "Strong",
  nmain.p,
  sigma = NULL,
  r1,
  r2,
  interaction.ind = NULL,
  pi1 = 0.32,
  pi2 = 0.32,
  pi3 = 0.32,
  lambda = 10,
  q = 40
)
}
\arguments{
\item{X}{Input data. An optional data frame, or numeric matrix of dimension
\code{n} by \code{nmain.p}. Note that the two-way interaction effects should not
be included in \code{X} because this function automatically generates the
corresponding two-way interaction effects if needed.}

\item{y}{Response variable. A \code{n}-dimensional vector, where \code{n} is the number
of observations in \code{X}.}

\item{heredity}{Whether to enforce Strong, Weak, or No heredity. Default is "Strong".}

\item{nmain.p}{A numeric value that represents the total number of main effects
in \code{X}.}

\item{sigma}{The standard deviation of the noise term. In practice, sigma is usually
unknown. In such case, this function automatically estimate sigma using root mean
square error (RMSE). Default is NULL. Otherwise, users need to enter a numeric value.}

\item{r1}{A numeric value indicating the maximum number of main effects.}

\item{r2}{A numeric value indicating the maximum number of interaction effects.}

\item{interaction.ind}{A two-column numeric matrix containing all possible
two-way interaction effects. It must be generated outside of this function
using \code{t(utils::combn())}. See Example section for details.}

\item{pi1}{A numeric value between 0 and 1, defined by users. Default is 0.32.
For guidance on selecting an appropriate value, please refer to \code{\link{ABC}}.}

\item{pi2}{A numeric value between 0 and 1, defined by users. Default is 0.32.
For guidance on selecting an appropriate value, please refer to \code{\link{ABC}}.}

\item{pi3}{A numeric value between 0 and 1, defined by users. Default is 0.32.
For guidance on selecting an appropriate value, please refer to \code{\link{ABC}}.}

\item{lambda}{A numeric value defined by users. Default is 10.
For guidance on selecting an appropriate value, please refer to \code{\link{ABC}}.}

\item{q}{A numeric value indicating the number of models in each generation (e.g.,
the population size). Default is 40.}
}
\value{
A \code{list} of output. The components are:
\item{InterRank}{Rank of all candidate interaction effects. A two-column numeric
matrix. The first column contains indices of ranked two-way interaction effects, and the
second column contains its corresponding ABC score.}
\item{mainind.sel}{Selected main effects.  A \code{r1}-dimensional vector.}
\item{mainpool}{Ranked main effects in \code{X}.}
\item{plot}{Plot of potential interaction effects and their corresponding ABC scores.}
}
\description{
This function suggests the values for \code{r2}.
}
\examples{
# under Strong heredity

# under No heredity
set.seed(0)
nmain.p <- 4
interaction.ind <- t(combn(4,2))
X <- matrix(rnorm(50*4,1,0.1), 50, 4)
epl <- rnorm(50,0,0.01)
y<- 1+X[,1]+X[,2]+X[,1]*X[,2]+epl
d2 <- detect(X, y, heredity = "No", nmain.p = 4, r1 = 3, r2 = 3,
    interaction.ind = interaction.ind, q = 5)

}
\seealso{
\code{\link{initial}}.
}
