% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulated_data.R
\docType{data}
\name{Simulated_data}
\alias{Simulated_data}
\title{Simulated Data}
\format{
A data frame with 5000 rows and 6 variables:
\describe{
\item{X}{a numeric vector generated from a standard normal distribution (mean = 0, standard deviation = 1)}
\item{X_star}{a numeric vector where X_star is equal to X plus a random error. The random error is generated from a normal distribution with mean 0 and standard deviation 0.1}
\item{Y}{a numeric vector generated from a Bernoulli distribution with a probability depending on T, Z, and X}
\item{Y_star}{a numeric vector where Y_star is generated from a binomial distribution depending on Y with probabilities 0.8 if Y equals 1 and 0.2 if Y equals 0}
\item{T}{a numeric vector generated from a binomial distribution with probability calculated using the logistic function of the sum of 0.2, Z, and X}
\item{Z}{a numeric vector generated from a standard normal distribution (mean = 0, standard deviation = 1)}
}
}
\source{
Shu D, Yi GY (2019). Weighted causal inference methods with mismeasured covariates and misclassified outcomes. Statistics in Medicine. 38:1835-1854. \doi{10.1002/sim.8073}
}
\usage{
Simulated_data
}
\description{
A dataset containing simulated data generated by the generate_data function.
This data includes misclassified outcome Y*, treatment assignment T,
and covariates X and Z.
}
\keyword{datasets}
