% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Naive.R
\name{Naive_Estimation}
\alias{Naive_Estimation}
\title{Naive Estimation of Average Treatment Effect}
\usage{
Naive_Estimation(Y_star, A, Z, X_star)
}
\arguments{
\item{Y_star}{A numeric vector of outcomes with potential misclassification.}

\item{A}{A numeric vector of treatment assignments.}

\item{Z}{A numeric vector of covariate Z.}

\item{X_star}{A numeric vector of covariate X with measurement error.}
}
\value{
A numeric value representing the estimated treatment effect.
}
\description{
This function performs a naive estimation of the ATE.
This approach gives us the so-called "naive estimate" by ignoring the difference between
(X*, Y*) and (X, Y).
}
\examples{
library(ATE.ERROR)
data(Simulated_data)
Y_star <- Simulated_data$Y_star
A <- Simulated_data$T
Z <- Simulated_data$Z
X_star <- Simulated_data$X_star
Naive_ATE_XY <- Naive_Estimation(Y_star, A, Z, X_star)
print(Naive_ATE_XY)
}
