% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ASSISTDesigns.R
\name{DEFUSE3Design}
\alias{DEFUSE3Design}
\title{The DEFUSE3 design}
\description{
\code{DEFUSE3Design} is a slight variant of the the adaptive
clinical trial design of Lai, Lavori and Liao. Simulation is used to compute
the expected maximum sample size and the boundary for early futility is adjusted to
account as well.
}
\examples{
trialParameters <- list(N = c(200, 340, 476), type1Error = 0.025,
                        eps = 1/2, type2Error = 0.1)
designParameters <- list(
   nul0 = list(prevalence = rep(1/6, 6), mean = matrix(0, 2, 6),
               sd = matrix(1, 2, 6)),
   alt1 = list(prevalence = rep(1/6, 6), mean = rbind(rep(0, 6),
               c(0.5, 0.4, 0.3, 0, 0, 0)),
               sd = matrix(1, 2, 6)),
   alt2 = list(prevalence = rep(1/6, 6), mean = rbind(rep(0, 6),
               c(0.5, 0.5, 0, 0, 0, 0)),
               sd = matrix(1,2, 6)),
   alt3 = list(prevalence = rep(1/6, 6), mean = rbind(rep(0, 6), rep(0.36, 6)),
               sd = matrix(1,2, 6)),
   alt4 = list(prevalence = rep(1/6, 6), mean = rbind(rep(0, 6), rep(0.30, 6)),
               sd = matrix(1,2, 6)),
   alt5 = list(prevalence = rep(1/6, 6), mean = rbind(rep(0, 6),
               c(0.4, 0.3, 0.2, 0, 0, 0)),
               sd = matrix(1,2, 6)),
   alt6 = list(prevalence = rep(1/6, 6), mean = rbind(rep(0, 6),
               c(0.5, 0.5, 0.3, 0.3, 0.1, 0.1)),
               sd = matrix(1,2, 6)))

\dontrun{
## A realistic design uses 5000 simulations or more!
defuse3 <- DEFUSE3Design$new(trialParameters = trialParameters,
                             numberOfSimulations = 25,
                             designParameters = designParameters$nul0,
                             showProgress = FALSE)
print(defuse3)
result <- defuse3$explore(showProgress = interactive())
analysis <- defuse3$analyze(result)
print(defuse3$summary(analysis))
}
## For full examples, try:
## browseURL(system.file("full_doc/defuse3.html", package="ASSISTant"))

}
\seealso{
\code{ASSISTDesign} which is a superclass of this object
}
\section{Super class}{
\code{\link[ASSISTant:ASSISTDesign]{ASSISTant::ASSISTDesign}} -> \code{DEFUSE3Design}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-DEFUSE3Design-getOriginalBoundaries}{\code{DEFUSE3Design$getOriginalBoundaries()}}
\item \href{#method-DEFUSE3Design-new}{\code{DEFUSE3Design$new()}}
\item \href{#method-DEFUSE3Design-adjustCriticalValues}{\code{DEFUSE3Design$adjustCriticalValues()}}
\item \href{#method-DEFUSE3Design-explore}{\code{DEFUSE3Design$explore()}}
\item \href{#method-DEFUSE3Design-performInterimLook}{\code{DEFUSE3Design$performInterimLook()}}
\item \href{#method-DEFUSE3Design-clone}{\code{DEFUSE3Design$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="ASSISTant" data-topic="ASSISTDesign" data-id="analyze"><a href='../../ASSISTant/html/ASSISTDesign.html#method-ASSISTDesign-analyze'><code>ASSISTant::ASSISTDesign$analyze()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ASSISTant" data-topic="ASSISTDesign" data-id="computeCriticalValues"><a href='../../ASSISTant/html/ASSISTDesign.html#method-ASSISTDesign-computeCriticalValues'><code>ASSISTant::ASSISTDesign$computeCriticalValues()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ASSISTant" data-topic="ASSISTDesign" data-id="getBoundaries"><a href='../../ASSISTant/html/ASSISTDesign.html#method-ASSISTDesign-getBoundaries'><code>ASSISTant::ASSISTDesign$getBoundaries()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ASSISTant" data-topic="ASSISTDesign" data-id="getDesignParameters"><a href='../../ASSISTant/html/ASSISTDesign.html#method-ASSISTDesign-getDesignParameters'><code>ASSISTant::ASSISTDesign$getDesignParameters()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ASSISTant" data-topic="ASSISTDesign" data-id="getTrialParameters"><a href='../../ASSISTant/html/ASSISTDesign.html#method-ASSISTDesign-getTrialParameters'><code>ASSISTant::ASSISTDesign$getTrialParameters()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ASSISTant" data-topic="ASSISTDesign" data-id="print"><a href='../../ASSISTant/html/ASSISTDesign.html#method-ASSISTDesign-print'><code>ASSISTant::ASSISTDesign$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ASSISTant" data-topic="ASSISTDesign" data-id="setBoundaries"><a href='../../ASSISTant/html/ASSISTDesign.html#method-ASSISTDesign-setBoundaries'><code>ASSISTant::ASSISTDesign$setBoundaries()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ASSISTant" data-topic="ASSISTDesign" data-id="summary"><a href='../../ASSISTant/html/ASSISTDesign.html#method-ASSISTDesign-summary'><code>ASSISTant::ASSISTDesign$summary()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DEFUSE3Design-getOriginalBoundaries"></a>}}
\if{latex}{\out{\hypertarget{method-DEFUSE3Design-getOriginalBoundaries}{}}}
\subsection{Method \code{getOriginalBoundaries()}}{
Return the original boundaries for the design
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DEFUSE3Design$getOriginalBoundaries()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
a named vector of values for \code{b}, \code{btilde} and \code{c}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DEFUSE3Design-new"></a>}}
\if{latex}{\out{\hypertarget{method-DEFUSE3Design-new}{}}}
\subsection{Method \code{new()}}{
Create a \code{DEFUSE3Design} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DEFUSE3Design$new(
  designParameters,
  trialParameters,
  discreteData = FALSE,
  numberOfSimulations = 5000,
  rngSeed = 54321,
  showProgress = TRUE,
  trueParameters = NULL,
  boundaries
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{designParameters}}{parameters of the experimental design. Must contain apropriate distributions to sample from, if \code{discreteData = TRUE}}

\item{\code{trialParameters}}{the trial parameters, such as sample size etc.}

\item{\code{discreteData}}{a flag indicating that a discrete distribution is to be used for the Rankin scores}

\item{\code{numberOfSimulations}}{the number of simulations to use, default 5000}

\item{\code{rngSeed}}{the random number generator seed}

\item{\code{showProgress}}{a boolean flag to show progress (default \code{TRUE})}

\item{\code{trueParameters}}{a list of true parameter values reflecting the state of nature}

\item{\code{boundaries}}{decision boundaries to use for interim looks, a named vector of \code{btilde}, \code{b} and \code{c} values}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a new \code{AssistDesign} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DEFUSE3Design-adjustCriticalValues"></a>}}
\if{latex}{\out{\hypertarget{method-DEFUSE3Design-adjustCriticalValues}{}}}
\subsection{Method \code{adjustCriticalValues()}}{
Adjust critical values to account for sample size loss due to futility
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DEFUSE3Design$adjustCriticalValues(numberOfSimulations, rngSeed, showProgress)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{numberOfSimulations}}{the number of simulations to use}

\item{\code{rngSeed}}{the random number generator seed}

\item{\code{showProgress}}{a boolean flag for showing progress}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the adjusted boundaries
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DEFUSE3Design-explore"></a>}}
\if{latex}{\out{\hypertarget{method-DEFUSE3Design-explore}{}}}
\subsection{Method \code{explore()}}{
Explore the design using the specified number of simulations and random number seed and other parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DEFUSE3Design$explore(
  numberOfSimulations = 5000,
  rngSeed = 12345,
  trueParameters = self$getDesignParameters(),
  recordStats = TRUE,
  showProgress = TRUE,
  saveRawData = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{numberOfSimulations}}{default number of simulations is 5000}

\item{\code{rngSeed}}{default seed is 12345}

\item{\code{trueParameters}}{the state of nature, by default the value of \code{self$getDesignParameters()} as would be the case for a Type I error calculation. If changed, would yield power.}

\item{\code{recordStats}}{a boolean flag (default \code{TRUE}) to record statistics}

\item{\code{showProgress}}{a boolean flag to show progress, default \code{TRUE}}

\item{\code{saveRawData}}{a flag (default \code{FALSE}) to indicate if raw data has to be saved}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a list of results
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DEFUSE3Design-performInterimLook"></a>}}
\if{latex}{\out{\hypertarget{method-DEFUSE3Design-performInterimLook}{}}}
\subsection{Method \code{performInterimLook()}}{
Perform an interim look for futility
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DEFUSE3Design$performInterimLook(trialData, stage, recordStats = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{trialData}}{trial data frame}

\item{\code{stage}}{the trial stage}

\item{\code{recordStats}}{a boolean flag to record all statistics}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the trial history
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DEFUSE3Design-clone"></a>}}
\if{latex}{\out{\hypertarget{method-DEFUSE3Design-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DEFUSE3Design$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
