% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ASSISTDesigns.R
\name{ASSISTDesign}
\alias{ASSISTDesign}
\title{A class to encapsulate the adaptive clinical trial design of Lai, Lavori and Liao}
\description{
\code{ASSISTDesign} objects are used to design, simulate and analyze
adaptive group sequential clinical trial with three stages. For details refer to the paper
\emph{Adaptive Choice of Patient Subgroup for Comparing Two Treatments}
by Tze Leung Lai and Philip W. Lavori and Olivia Yueh-Wen Liao. Contemporary Clinical Trials,
Vol. 39, No. 2, pp 191-200 (2014).
}
\examples{
\dontrun{
data(LLL.SETTINGS)
prevalence <- LLL.SETTINGS$prevalences$table1
scenario <- LLL.SETTINGS$scenarios$S0
designParameters <- list(prevalence = prevalence,
                         mean = scenario$mean,
                         sd = scenario$sd)
designA <- ASSISTDesign$new(trialParameters = LLL.SETTINGS$trialParameters,
                              designParameters = designParameters)
print(designA)
result <- designA$explore(showProgress = interactive())
analysis <- designA$analyze(result)
designA$summary(analysis)
}
}
\seealso{
\code{LLL.SETTINGS} for an explanation of trial parameters
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ASSISTDesign-new}{\code{ASSISTDesign$new()}}
\item \href{#method-ASSISTDesign-getDesignParameters}{\code{ASSISTDesign$getDesignParameters()}}
\item \href{#method-ASSISTDesign-getTrialParameters}{\code{ASSISTDesign$getTrialParameters()}}
\item \href{#method-ASSISTDesign-getBoundaries}{\code{ASSISTDesign$getBoundaries()}}
\item \href{#method-ASSISTDesign-setBoundaries}{\code{ASSISTDesign$setBoundaries()}}
\item \href{#method-ASSISTDesign-print}{\code{ASSISTDesign$print()}}
\item \href{#method-ASSISTDesign-computeCriticalValues}{\code{ASSISTDesign$computeCriticalValues()}}
\item \href{#method-ASSISTDesign-explore}{\code{ASSISTDesign$explore()}}
\item \href{#method-ASSISTDesign-performInterimLook}{\code{ASSISTDesign$performInterimLook()}}
\item \href{#method-ASSISTDesign-analyze}{\code{ASSISTDesign$analyze()}}
\item \href{#method-ASSISTDesign-summary}{\code{ASSISTDesign$summary()}}
\item \href{#method-ASSISTDesign-clone}{\code{ASSISTDesign$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ASSISTDesign-new"></a>}}
\if{latex}{\out{\hypertarget{method-ASSISTDesign-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{ASSISTDesign} instance using the parameters specified.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ASSISTDesign$new(
  designParameters,
  trialParameters,
  discreteData = FALSE,
  boundaries
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{designParameters}}{parameters of the experimental design. Must contain apropriate distributions to sample from, if \code{discreteData = TRUE}}

\item{\code{trialParameters}}{the trial parameters, such as sample size etc.}

\item{\code{discreteData}}{a flag indicating that a discrete distribution is to be used for the Rankin scores}

\item{\code{boundaries}}{decision boundaries to use for interim looks, a named vector of \code{btilde}, \code{b} and \code{c} values}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a new \code{AssistDesign} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ASSISTDesign-getDesignParameters"></a>}}
\if{latex}{\out{\hypertarget{method-ASSISTDesign-getDesignParameters}{}}}
\subsection{Method \code{getDesignParameters()}}{
return the designParameters field
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ASSISTDesign$getDesignParameters()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ASSISTDesign-getTrialParameters"></a>}}
\if{latex}{\out{\hypertarget{method-ASSISTDesign-getTrialParameters}{}}}
\subsection{Method \code{getTrialParameters()}}{
return the trialParameters field
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ASSISTDesign$getTrialParameters()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ASSISTDesign-getBoundaries"></a>}}
\if{latex}{\out{\hypertarget{method-ASSISTDesign-getBoundaries}{}}}
\subsection{Method \code{getBoundaries()}}{
return the boundaries field
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ASSISTDesign$getBoundaries()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ASSISTDesign-setBoundaries"></a>}}
\if{latex}{\out{\hypertarget{method-ASSISTDesign-setBoundaries}{}}}
\subsection{Method \code{setBoundaries()}}{
Set the boundaries field
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ASSISTDesign$setBoundaries(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{a named vector of \code{btilde}, \code{b} and \code{c} values}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ASSISTDesign-print"></a>}}
\if{latex}{\out{\hypertarget{method-ASSISTDesign-print}{}}}
\subsection{Method \code{print()}}{
Print details of the design to console
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ASSISTDesign$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ASSISTDesign-computeCriticalValues"></a>}}
\if{latex}{\out{\hypertarget{method-ASSISTDesign-computeCriticalValues}{}}}
\subsection{Method \code{computeCriticalValues()}}{
Compute the critical boundary values \eqn{\tilde{b}}, \eqn{b} and \eqn{c} for futility, efficacy and final efficacy decisions. This is time consuming so cache where possible.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ASSISTDesign$computeCriticalValues()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
a named vector of critical values with names \code{btilde}, \code{b}, and \code{c} as in the paper
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ASSISTDesign-explore"></a>}}
\if{latex}{\out{\hypertarget{method-ASSISTDesign-explore}{}}}
\subsection{Method \code{explore()}}{
Explore the design using the specified number of simulations and random number seed and other parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ASSISTDesign$explore(
  numberOfSimulations = 5000,
  rngSeed = 12345,
  trueParameters = self$getDesignParameters(),
  recordStats = TRUE,
  showProgress = TRUE,
  fixedSampleSize = FALSE,
  saveRawData = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{numberOfSimulations}}{default number of simulations is 5000}

\item{\code{rngSeed}}{default seed is 12345}

\item{\code{trueParameters}}{the state of nature, by default the value of \code{self$getDesignParameters()} as would be the case for a Type I error calculation. If changed, would yield power.}

\item{\code{recordStats}}{a boolean flag (default \code{TRUE}) to record statistics}

\item{\code{showProgress}}{a boolean flag to show progress, default \code{TRUE}}

\item{\code{fixedSampleSize}}{a bollean flag indicating that patients lost after a futile overall look are not made up, default \code{FALSE}.}

\item{\code{saveRawData}}{a flag (default \code{FALSE}) to indicate if raw data has to be saved}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a list of results
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ASSISTDesign-performInterimLook"></a>}}
\if{latex}{\out{\hypertarget{method-ASSISTDesign-performInterimLook}{}}}
\subsection{Method \code{performInterimLook()}}{
Perform an interim look on trial data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ASSISTDesign$performInterimLook(
  trialData,
  stage,
  recordStats = FALSE,
  fixedSampleSize = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{trialData}}{trial data frame}

\item{\code{stage}}{the trial stage}

\item{\code{recordStats}}{a boolean flag to record all statistics}

\item{\code{fixedSampleSize}}{a flag to use a fixed sample size to account for loss to follow up}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the trial history
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ASSISTDesign-analyze"></a>}}
\if{latex}{\out{\hypertarget{method-ASSISTDesign-analyze}{}}}
\subsection{Method \code{analyze()}}{
Analyze the exploration data from trial
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ASSISTDesign$analyze(trialExploration)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{trialExploration}}{the result of a call to \code{explore()} to simulate the design}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Return a list of summary quantities
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ASSISTDesign-summary"></a>}}
\if{latex}{\out{\hypertarget{method-ASSISTDesign-summary}{}}}
\subsection{Method \code{summary()}}{
Print the operating characteristics of the design using the analysis data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ASSISTDesign$summary(analysis)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{analysis}}{the analysis result from the \code{analyze()} call}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ASSISTDesign-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ASSISTDesign-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ASSISTDesign$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
