% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataSimulation.R
\name{simDat5}
\alias{simDat5}
\title{Simulate data for Chapter 5: Simple linear regression}
\usage{
simDat5(n = 16, a = 40, b = -0.5, sigma2 = 25)
}
\arguments{
\item{n}{The sample size}

\item{a}{Value for the intercept}

\item{b}{Value for the slope}

\item{sigma2}{Value for the residual variance}
}
\value{
A list of simulated data and parameters.
  \item{n}{Sample size}
  \item{a}{Intercept}
  \item{b}{Slope}
  \item{sd}{Residual SD}
  \item{y}{Simulated wallcreeper occupancy probabilities}
}
\description{
Simulate percent occupancy population trajectory of Swiss Wallcreepers
from a normal distribution. Note that other choices of arguments may
lead to values for x and y that no longer make sense in the light of
the story in Chapter 5 (i.e., where y is a percentage), but will
still be OK for the statistical model introduced in that chapter.
}
\examples{
str(dat <- simDat5())        # Implicit default arguments
str(dat <- simDat5(b = 0))    # Stable population (this is a de-facto "model-of-the-mean")
str(dat <- simDat5(b = 0.5)) # Expected increase

}
\author{
Marc Kéry
}
