% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsers.R
\name{parse_formula}
\alias{parse_formula}
\title{Formula parser}
\usage{
parse_formula(formula, colnames_data)
}
\arguments{
\item{formula}{A "formula" describing the linear model. Details for model
specification are given under 'Details'.}

\item{colnames_data}{A character vector containing the colnames of the data
used in the formula (usually via \code{colnames(data)}).}
}
\value{
A list containing other lists with the names of the dependent,
  independent and fixed variables, the constant and linear trends and the
  number of variables in each category.
}
\description{
It parses the formula and separates the dependent, independent and fixed
variables and also the constant and linear trends (if present).
}
\details{
The notation we follow (e.g., using y, x, z, w etc.) is according to
\cite{Pesaran et al. (2001)}.

The \code{formula} should contain only variables that exist in the data
provided through \code{data} plus some additional functions supported by
\code{\link[dynlm]{dynlm}} (i.e., \code{trend()}).

You can also specify fixed variables that are not supposed to be lagged (e.g.
dummies etc.) simply by placing them after \code{|}. For example, \code{y ~
x1 + x2 | z1 + z2} where \code{z1} and \code{z2} are the fixed variables and
should not be considered in \code{order}. Note that the \code{|} notion
should not be confused with the same notion in \code{dynlm} where it
introduces instrumental variables.
}
\section{References}{
 Pesaran, M. H., Shin, Y., & Smith, R. J. (2001). Bounds
  testing approaches to the analysis of level relationships. \emph{Journal of
  Applied Econometrics}, 16(3), 289-326
}

\seealso{
\code{\link{parse_order}}
}
\author{
Kleanthis Natsiopoulos, \email{klnatsio@gmail.com}
}
\keyword{internal}
