% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delta_method.R
\name{delta_method}
\alias{delta_method}
\alias{delta_method.ardl}
\alias{delta_method.uecm}
\title{Delta method}
\usage{
delta_method(object, vcov_matrix = NULL)

\method{delta_method}{ardl}(object, vcov_matrix = NULL)

\method{delta_method}{uecm}(object, vcov_matrix = NULL)
}
\arguments{
\item{object}{An object of \code{\link[base]{class}} 'ardl' or 'uecm'.}

\item{vcov_matrix}{The estimated covariance matrix of the random variable
that the transformation function uses to estimate the standard errors (and
so the t-statistics and p-values) of the multipliers. The default is
\code{vcov(object)} (when \code{vcov_matrix = NULL}), but other estimations
of the covariance matrix of the regression's estimated coefficients can
also be used (e.g., using \code{\link[sandwich]{vcovHC}} or
\code{\link[sandwich]{vcovHAC}}).}
}
\value{
\code{delta_method} returns a numeric vector of the same length as
  the number of the independent variables (excluding the fixed ones) in the
  model.
}
\description{
An internal generic function, customized for approximating the standard
errors of the estimated multipliers.
}
\details{
The function invokes two different \code{\link[utils]{methods}}, one for
objects of \code{\link[base]{class}} 'ardl' and one for objects of
\code{class} 'uecm'. This is because of the different (but equivalent)
transformation functions that are used for each class/model ('ardl' and
'uecm') to estimate the multipliers.
}
\seealso{
\code{\link{multipliers}}, \code{\link{ardl}}, \code{\link{uecm}}
}
\author{
Kleanthis Natsiopoulos, \email{klnatsio@gmail.com}
}
\keyword{internal}
