AAZ14Multiple<-function(PLAN,INSL,LOTS,AQL){
  message("MIL-STD-105E ANSI/ASQ Z1.4")
  # Get the inspection level
  dINSL <- menu(c("S-1", "S-2", "S-3", "S-4",
                  "I", "II", "III"), title = "\nWhat is the Inspection Level?")
  INSL
  # Get the lot size
  dLOTS <- menu(c("2-8", "9-15", "16-25", "26-50",
                  "51-90", "91-150", "151-280", "281-500",
                  "501-1200", "1201-3200", "3201-10,000",
                  "10,001-35,000", "35,001-150,000", "150,001-500,000",
                  "500,001 and over"), title = "\nWhat is the Lot Size?")
  LOTS
  # Get the AQL
  dAQL <- menu(c("0.010","0.015","0.025","0.040","0.065","0.10","0.15","0.25",
                 "0.40","0.65","1.0","1.5","2.5","4.0","6.5","10",
                 "15","25","40","65","100","150","250","400","650","1000"),
               title = "\nWhat is the AQL in percent nonconforming per 100 items?")
  AQL

  #Create matrix of Code Letters
  codes<-c("A","B","C","D","E","F","G","H","J","K","L","M","N","P","Q","R")
  InspLev<-c("S-1","S-2","S-3","S-4","I","II","III")
  LotSize<-c("2-8","9-15","16-25","26-50","51-90","91-150","151-280","281-500","501-1200","1201-3200","3201-10,000","10,001-35,000","35,001-150,000","150,001-500,000","over 500,001")
  AQL<-c("0.010","0.015","0.025","0.040","0.065","0.10","0.15","0.25","0.40","0.65","1.0","1.5","2.5","4.0","6.5","10","15","25","40","65","100","150","250","400","650","1000")
  letters<-c("A","A","A","A","A","A","B",
             "A","A","A","A","A","B","C",
             "A","A","B","B","B","C","D",
             "A","B","B","C","C","D","E",
             "B","B","C","C","C","E","F",
             "B","B","C","D","D","F","G",
             "B","C","D","E","E","G","H",
             "B","C","D","E","F","H","J",
             "C","C","E","F","G","J","K",
             "C","D","E","G","H","K","L",
             "C","D","F","G","J","L","M",
             "C","D","F","H","K","M","N",
             "D","E","G","J","L","N","P",
             "D","E","G","J","M","P","Q",
             "D","E","H","K","N","Q","R")
  SSCodeLetters<-matrix(letters,nrow=15, byrow=TRUE)
  rownames(SSCodeLetters)<-LotSize
  colnames(SSCodeLetters)<-InspLev
  #Create Matrix of Multiple Sample Sizes for Normal Sampling
  temp<-array(c(-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,
                -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,
                -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,
                -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,2,2,2,2,2,2,2,2,2,2,-2,-2,
                -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,5,3,3,3,3,3,3,3,3,3,3,2,-2,-2,
                -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,5,5,5,5,5,5,5,5,5,5,3,2,-2,-2,
                -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,13,8,8,8,8,8,8,8,8,5,3,3,3,2,-2,-2,
                -1,-1,-1,-1,-1,-1,-1,-1,-1,20,13,13,13,13,13,13,13,13,8,5,3,3,3,2,-2,-2,
                -1,-1,-1,-1,-1,-1,-1,-1,32,20,20,20,20,20,20,20,20,13,8,5,3,3,3,2,-2,-2,
                -1,-1,-1,-1,-1,-1,-1,50,32,32,32,32,32,32,32,32,20,13,8,5,3,3,3,2,-2,-2,
                -1,-1,-1,-1,-1,-1,80,50,50,50,50,50,50,50,50,32,20,13,8,5,3,3,3,2,-2,-2,
                -1,-1,-1,-1,-1,125,80,80,80,80,80,80,80,80,50,32,20,13,8,5,3,3,3,2,-2,-2,
                -1,-1,-1,-1,200,125,125,125,125,125,125,125,125,80,50,32,20,13,8,5,3,3,3,2,-2,-2,
                -1,-1,-1,315,200,200,200,200,200,200,200,200,125,80,50,32,20,13,8,5,3,3,3,2,-2,-2,
                -1,-1,500,315,315,315,315,315,315,315,315,200,125,80,50,32,20,13,8,5,3,3,3,2,-2,-2,
                -1,-1,500,500,500,500,500,500,500,500,315,200,125,80,50,32,20,13,8,5,3,3,3,2,-2,-2),
              dim=c(26,16))
  AAMultipleNormalss <- t(temp)
  rownames(AAMultipleNormalss)<-codes
  colnames(AAMultipleNormalss)<-AQL
  #Create Matrix of Multiple Sample Sizes for Tightened Sampling
  temp<-array(c(-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,-2,-2,-1,-1,-1,-1,-1,-1,-1,-1,
                -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,
                -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,
                -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,5,3,2,2,2,2,2,2,2,2,2,-2,-2,
                -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,8,5,3,3,3,3,3,3,3,3,3,2,-2,-2,
                -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,13,8,5,5,5,5,5,5,5,3,3,3,2,-2,-2,
                -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,20,13,8,8,8,8,8,8,8,5,3,3,3,2,-2,-2,
                -1,-1,-1,-1,-1,-1,-1,-1,-1,32,20,13,13,13,13,13,13,13,8,5,3,3,3,2,-2,-2,
                -1,-1,-1,-1,-1,-1,-1,-1,50,32,20,20,20,20,20,20,20,13,8,5,3,3,3,2,-2,-2,
                -1,-1,-1,-1,-1,-1,-1,80,50,32,32,32,32,32,32,32,20,13,8,5,3,3,3,2,-2,-2,
                -1,-1,-1,-1,-1,-1,125,80,50,50,50,50,50,50,50,32,20,13,8,5,3,3,3,2,-2,-2,
                -1,-1,-1,-1,-1,200,125,80,80,80,80,80,80,80,50,32,20,13,8,5,3,3,3,2,-2,-2,
                -1,-1,-1,-1,315,200,125,125,125,125,125,125,125,80,50,32,20,13,8,5,3,3,3,2,-2,-2,
                -1,-1,-1,500,315,200,200,200,200,200,200,200,125,80,50,32,20,13,8,5,3,3,3,2,-2,-2,
                -1,-1,800,500,315,315,315,315,315,315,315,200,125,80,50,32,20,13,8,5,3,3,3,2,-2,-2,
                -1,-1,800,500,500,500,500,500,500,500,315,200,125,80,50,32,20,13,8,5,3,3,3,2,-2,-2),
              dim=c(26,16))
  AAMultipleTightenedss<-t(temp)
  rownames(AAMultipleTightenedss)<-codes
  colnames(AAMultipleTightenedss)<-AQL
  #Create Matrix of Multiple Sample Sizes for Reduced Sampling
  temp<-array(c(-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
                -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
                -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
                -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,
                -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-2,-1,-1,
                -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,3,2,2,2,2,2,2,2,2,-2,-2,-2,-2,-1,-1,
                -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,5,3,3,3,3,3,3,3,3,2,-2,-2,-2,-2,-1,-1,
                -1,-1,-1,-1,-1,-1,-1,-1,-1,8,5,5,5,5,5,5,5,5,3,2,-2,-2,-2,-2,-1,-1,
                -1,-1,-1,-1,-1,-1,-1,-1,13,8,8,8,8,8,8,8,8,5,3,2,-2,-2,-2,-2,-1,-1,
                -1,-1,-1,-1,-1,-1,-1,20,13,13,13,13,13,13,13,13,8,5,3,2,-2,-2,-2,-2,-1,-1,
                -1,-1,-1,-1,-1,-1,32,20,20,20,20,20,20,20,20,13,8,5,3,2,-2,-2,-2,-2,-1,-1,
                -1,-1,-1,-1,-1,50,32,32,32,32,32,32,32,32,20,13,8,5,3,2,-2,-2,-2,-2,-1,-1,
                -1,-1,-1,-1,80,50,50,50,50,50,50,50,50,32,20,13,8,5,3,2,-2,-2,-2,-2,-1,-1,
                -1,-1,-1,125,80,80,80,80,80,80,80,80,50,32,20,13,8,5,3,2,-2,-2,-2,-2,-1,-1,
                -1,-1,200,125,125,125,125,125,125,125,125,80,50,32,20,13,8,5,3,2,-2,-2,-2,-2,-1,-1,
                -1,-1,200,200,200,200,200,200,200,200,125,80,50,32,20,13,8,5,3,2,-2,-2,-2,-2,-1,-1),
              dim=c(26,16))
              AAMultipleReducedss<-t(temp)
              rownames(AAMultipleReducedss)<-codes
              colnames(AAMultipleReducedss)<-AQL
  #Create array of Acceptance Numbers for Normal Multiple Sampling
  t<-c(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,0,0,1,2,4,6,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,3,4,7,11,17,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,6,8,13,19,29,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,5,8,12,19,27,40,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,5,7,11,17,25,36,53,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,7,10,14,21,31,45,65,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,9,13,18,25,37,53,77,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,0,0,1,2,4,6,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,0,0,1,1,3,4,7,11,17,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,6,8,13,19,29,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,5,8,12,19,27,40,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,5,7,11,17,25,36,53,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,3,4,7,10,14,21,31,45,65,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,4,6,9,13,18,25,37,53,77,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,0,0,1,2,4,6,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,0,0,1,1,3,4,7,11,17,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,6,8,13,19,29,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,5,8,12,19,27,40,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,3,5,7,11,17,25,36,53,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,3,4,7,10,14,21,31,45,65,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,4,6,9,13,18,25,37,53,77,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,0,0,1,2,4,6,6,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,0,0,1,1,3,4,7,11,17,17,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,6,8,13,19,29,29,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,5,8,12,19,27,40,40,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,3,5,7,11,17,25,36,53,53,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,1,1,3,4,7,10,14,21,31,45,65,65,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,2,2,4,6,9,13,18,25,37,53,77,77,0,0,
       0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,0,0,1,2,2,4,6,6,0,0,
       0,0,0,0,0,0,0,0,0,0,0,-1,-1,0,0,1,1,3,4,7,7,11,17,17,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,6,8,13,13,19,29,29,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,5,8,12,19,19,27,40,40,0,0,
       0,0,0,0,0,0,0,0,0,0,0,1,1,2,3,5,7,11,17,25,25,36,53,53,0,0,
       0,0,0,0,0,0,0,0,0,0,0,1,1,3,4,7,10,14,21,31,31,45,65,65,0,0,
       0,0,0,0,0,0,0,0,0,0,0,2,2,4,6,9,13,18,25,37,37,53,77,77,0,0,
       0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,0,0,1,2,2,2,4,6,6,0,0,
       0,0,0,0,0,0,0,0,0,0,-1,-1,0,0,1,1,3,4,7,7,7,11,17,17,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,6,8,13,13,13,19,29,29,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,5,8,12,19,19,19,27,40,40,0,0,
       0,0,0,0,0,0,0,0,0,0,1,1,2,3,5,7,11,17,25,25,25,36,53,53,0,0,
       0,0,0,0,0,0,0,0,0,0,1,1,3,4,7,10,14,21,31,31,31,45,65,65,0,0,
       0,0,0,0,0,0,0,0,0,0,2,2,4,6,9,13,18,25,37,37,37,53,77,77,0,0,
       0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,0,0,1,2,2,2,2,4,6,6,0,0,
       0,0,0,0,0,0,0,0,0,-1,-1,0,0,1,1,3,4,7,7,7,7,11,17,17,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,6,8,13,13,13,13,19,29,29,0,0,
       0,0,0,0,0,0,0,0,0,0,0,1,2,3,5,8,12,19,19,19,19,27,40,40,0,0,
       0,0,0,0,0,0,0,0,0,1,1,2,3,5,7,11,17,25,25,25,25,36,53,53,0,0,
       0,0,0,0,0,0,0,0,0,1,1,3,4,7,10,14,21,31,31,31,31,45,65,65,0,0,
       0,0,0,0,0,0,0,0,0,2,2,4,6,9,13,18,25,37,37,37,37,53,77,77,0,0,
       0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,0,0,1,2,2,2,2,2,4,6,6,0,0,
       0,0,0,0,0,0,0,0,-1,-1,0,0,1,1,3,4,7,7,7,7,7,11,17,17,0,0,
       0,0,0,0,0,0,0,0,0,0,0,1,2,3,6,8,13,13,13,13,13,19,29,29,0,0,
       0,0,0,0,0,0,0,0,0,0,1,2,3,5,8,12,19,19,19,19,19,27,40,40,0,0,
       0,0,0,0,0,0,0,0,1,1,2,3,5,7,11,17,25,25,25,25,25,36,53,53,0,0,
       0,0,0,0,0,0,0,0,1,1,3,4,7,10,14,21,31,31,31,31,31,45,65,65,0,0,
       0,0,0,0,0,0,0,0,2,2,4,6,9,13,18,25,37,37,37,37,37,53,77,77,0,0,
       0,0,0,0,0,0,0,-1,-1,-1,-1,-1,0,0,1,2,2,2,2,2,2,4,6,6,0,0,
       0,0,0,0,0,0,0,-1,-1,0,0,1,1,3,4,7,7,7,7,7,7,11,17,17,0,0,
       0,0,0,0,0,0,0,0,0,0,1,2,3,6,8,13,13,13,13,13,13,19,29,29,0,0,
       0,0,0,0,0,0,0,0,0,1,2,3,5,8,12,19,19,19,19,19,19,27,40,40,0,0,
       0,0,0,0,0,0,0,1,1,2,3,5,7,11,17,25,25,25,25,25,25,36,53,53,0,0,
       0,0,0,0,0,0,0,1,1,3,4,7,10,14,21,31,31,31,31,31,31,45,65,65,0,0,
       0,0,0,0,0,0,0,2,2,4,6,9,13,18,25,37,37,37,37,37,37,53,77,77,0,0,
       0,0,0,0,0,0,-1,-1,-1,-1,-1,0,0,1,2,2,2,2,2,2,2,4,6,6,0,0,
       0,0,0,0,0,0,-1,-1,0,0,1,1,3,4,7,7,7,7,7,7,7,11,17,17,0,0,
       0,0,0,0,0,0,0,0,0,1,2,3,6,8,13,13,13,13,13,13,13,19,29,29,0,0,
       0,0,0,0,0,0,0,0,1,2,3,5,8,12,19,19,19,19,19,19,19,27,40,40,0,0,
       0,0,0,0,0,0,1,1,2,3,5,7,11,17,25,25,25,25,25,25,25,36,53,53,0,0,
       0,0,0,0,0,0,1,1,3,4,7,10,14,21,31,31,31,31,31,31,31,45,65,65,0,0,
       0,0,0,0,0,0,2,2,4,6,9,13,18,25,37,37,37,37,37,37,37,53,77,77,0,0,
       0,0,0,0,0,-1,-1,-1,-1,-1,0,0,1,2,2,2,2,2,2,2,2,4,6,6,0,0,
       0,0,0,0,0,-1,-1,0,0,1,1,3,4,7,7,7,7,7,7,7,7,11,17,17,0,0,
       0,0,0,0,0,0,0,0,1,2,3,6,8,13,13,13,13,13,13,13,13,19,29,29,0,0,
       0,0,0,0,0,0,0,1,2,3,5,8,12,19,19,19,19,19,19,19,19,27,40,40,0,0,
       0,0,0,0,0,1,1,2,3,5,7,11,17,25,25,25,25,25,25,25,25,36,53,53,0,0,
       0,0,0,0,0,1,1,3,4,7,10,14,21,31,31,31,31,31,31,31,31,45,65,65,0,0,
       0,0,0,0,0,2,2,4,6,9,13,18,25,37,37,37,37,37,37,37,37,53,77,77,0,0,
       0,0,0,0,-1,-1,-1,-1,-1,0,0,1,2,2,2,2,2,2,2,2,2,4,6,6,0,0,
       0,0,0,0,-1,-1,0,0,1,1,3,4,7,7,7,7,7,7,7,7,7,11,17,17,0,0,
       0,0,0,0,0,0,0,1,2,3,6,8,13,13,13,13,13,13,13,13,13,19,29,29,0,0,
       0,0,0,0,0,0,1,2,3,5,8,12,19,19,19,19,19,19,19,19,19,27,40,40,0,0,
       0,0,0,0,1,1,2,3,5,7,11,17,25,25,25,25,25,25,25,25,25,36,53,53,0,0,
       0,0,0,0,1,1,3,4,7,10,14,21,31,31,31,31,31,31,31,31,31,45,65,65,0,0,
       0,0,0,0,2,2,4,6,9,13,18,25,37,37,37,37,37,37,37,37,37,53,77,77,0,0,
       0,0,0,-1,-1,-1,-1,-1,0,0,1,2,2,2,2,2,2,2,2,2,2,4,6,6,0,0,
       0,0,0,-1,-1,0,0,1,1,3,4,7,7,7,7,7,7,7,7,7,7,11,17,17,0,0,
       0,0,0,0,0,0,1,2,3,6,8,13,13,13,13,13,13,13,13,13,13,19,29,29,0,0,
       0,0,0,0,0,1,2,3,5,8,12,19,19,19,19,19,19,19,19,19,19,27,40,40,0,0,
       0,0,0,1,1,2,3,5,7,11,17,25,25,25,25,25,25,25,25,25,25,36,53,53,0,0,
       0,0,0,1,1,3,4,7,10,14,21,31,31,31,31,31,31,31,31,31,31,45,65,65,0,0,
       0,0,0,2,2,4,6,9,13,18,25,37,37,37,37,37,37,37,37,37,37,53,77,77,0,0,
       0,0,-1,-1,-1,-1,-1,0,0,1,2,2,2,2,2,2,2,2,2,2,2,4,6,6,0,0,
       0,0,-1,-1,0,0,1,1,3,4,7,7,7,7,7,7,7,7,7,7,7,11,17,17,0,0,
       0,0,0,0,0,1,2,3,6,8,13,13,13,13,13,13,13,13,13,13,13,19,29,29,0,0,
       0,0,0,0,1,2,3,5,8,12,19,19,19,19,19,19,19,19,19,19,19,27,40,40,0,0,
       0,0,1,1,2,3,5,7,11,17,25,25,25,25,25,25,25,25,25,25,25,36,53,53,0,0,
       0,0,1,1,3,4,7,10,14,21,31,31,31,31,31,31,31,31,31,31,31,45,65,65,0,0,
       0,0,2,2,4,6,9,13,18,25,37,37,37,37,37,37,37,37,37,37,37,53,77,77,0,0,
       0,0,-1,-1,-1,-1,0,0,1,2,2,2,2,2,2,2,2,2,2,2,2,4,6,6,0,0,
       0,0,-1,0,0,1,1,3,4,7,7,7,7,7,7,7,7,7,7,7,7,11,17,17,0,0,
       0,0,0,0,1,2,3,6,8,13,13,13,13,13,13,13,13,13,13,13,13,19,29,29,0,0,
       0,0,0,1,2,3,5,8,12,19,19,19,19,19,19,19,19,19,19,19,19,27,40,40,0,0,
       0,0,1,2,3,5,7,11,17,25,25,25,25,25,25,25,25,25,25,25,25,36,53,53,0,0,
       0,0,1,3,4,7,10,14,21,31,31,31,31,31,31,31,31,31,31,31,31,45,65,65,0,0,
       0,0,2,4,6,9,13,18,25,37,37,37,37,37,37,37,37,37,37,37,37,53,77,77,0,0)
  AAMultipleNormalac<-array(t, dim=c(26,7,16), dimnames=list(c("0.010","0.015","0.025","0.040","0.065","0.10","0.15","0.25","0.40","0.65","1.0","1.5","2.5","4.0","6.5",
                                                                "10","15","25","40","65","100","150","250","400","650","1000"),
                                                              c("first","second","third","fourth","fifth","sixth","seventh"),
                                                           c("A","B","C","D","E","F","G","H","J","K","L","M","N","P","Q","R")
                                                           ))
  # Create array of Rejection Numbers for Normal Multiple Sampling
  t<-c(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,4,4,5,7,9,12,16,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,5,6,8,10,14,19,27,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,4,6,8,10,13,19,27,39,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,5,7,10,13,17,25,34,49,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,6,8,11,15,20,29,40,58,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,6,9,12,17,23,33,47,68,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,7,10,14,19,26,38,54,78,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,3,4,4,5,7,9,12,16,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,3,5,6,8,10,14,19,27,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,4,6,8,10,13,19,27,39,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,4,5,7,10,13,17,25,34,49,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,4,6,8,11,15,20,29,40,58,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,5,6,9,12,17,23,33,47,68,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,5,7,10,14,19,26,38,54,78,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,3,4,4,5,7,9,12,16,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,3,3,5,6,8,10,14,19,27,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,3,4,6,8,10,13,19,27,39,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,4,5,7,10,13,17,25,34,49,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,4,6,8,11,15,20,29,40,58,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,5,6,9,12,17,23,33,47,68,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,5,7,10,14,19,26,38,54,78,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,3,4,4,5,7,9,12,16,16,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,2,2,3,3,5,6,8,10,14,19,27,27,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,2,2,3,4,6,8,10,13,19,27,39,39,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,3,3,4,5,7,10,13,17,25,34,49,49,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,3,3,4,6,8,11,15,20,29,40,58,58,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,3,3,5,6,9,12,17,23,33,47,68,68,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,3,3,5,7,10,14,19,26,38,54,78,78,0,0,
       0,0,0,0,0,0,0,0,0,0,0,2,2,2,3,4,4,5,7,9,9,12,16,16,0,0,
       0,0,0,0,0,0,0,0,0,0,0,2,2,3,3,5,6,8,10,14,14,19,27,27,0,0,
       0,0,0,0,0,0,0,0,0,0,0,2,2,3,4,6,8,10,13,19,19,27,39,39,0,0,
       0,0,0,0,0,0,0,0,0,0,0,3,3,4,5,7,10,13,17,25,25,34,49,49,0,0,
       0,0,0,0,0,0,0,0,0,0,0,3,3,4,6,8,11,15,20,29,29,40,58,58,0,0,
       0,0,0,0,0,0,0,0,0,0,0,3,3,5,6,9,12,17,23,33,33,47,68,68,0,0,
       0,0,0,0,0,0,0,0,0,0,0,3,3,5,7,10,14,19,26,38,38,54,78,78,0,0,
       0,0,0,0,0,0,0,0,0,0,2,2,2,3,4,4,5,7,9,9,9,12,16,16,0,0,
       0,0,0,0,0,0,0,0,0,0,2,2,3,3,5,6,8,10,14,14,14,19,27,27,0,0,
       0,0,0,0,0,0,0,0,0,0,2,2,3,4,6,8,10,13,19,19,19,27,39,39,0,0,
       0,0,0,0,0,0,0,0,0,0,3,3,4,5,7,10,13,17,25,25,25,34,49,49,0,0,
       0,0,0,0,0,0,0,0,0,0,3,3,4,6,8,11,15,20,29,29,29,40,58,58,0,0,
       0,0,0,0,0,0,0,0,0,0,3,3,5,6,9,12,17,23,33,33,33,47,68,68,0,0,
       0,0,0,0,0,0,0,0,0,0,3,3,5,7,10,14,19,26,38,38,38,54,78,78,0,0,
       0,0,0,0,0,0,0,0,0,2,2,2,3,4,4,5,7,9,9,9,9,12,16,16,0,0,
       0,0,0,0,0,0,0,0,0,2,2,3,3,5,6,8,10,14,14,14,14,19,27,27,0,0,
       0,0,0,0,0,0,0,0,0,2,2,3,4,6,8,10,13,19,19,19,19,27,39,39,0,0,
       0,0,0,0,0,0,0,0,0,3,3,4,5,7,10,13,17,25,25,25,25,34,49,49,0,0,
       0,0,0,0,0,0,0,0,0,3,3,4,6,8,11,15,20,29,29,29,29,40,58,58,0,0,
       0,0,0,0,0,0,0,0,0,3,3,5,6,9,12,17,23,33,33,33,33,47,68,68,0,0,
       0,0,0,0,0,0,0,0,0,3,3,5,7,10,14,19,26,38,38,38,38,54,78,78,0,0,
       0,0,0,0,0,0,0,0,2,2,2,3,4,4,5,7,9,9,9,9,9,12,16,16,0,0,
       0,0,0,0,0,0,0,0,2,2,3,3,5,6,8,10,14,14,14,14,14,19,27,27,0,0,
       0,0,0,0,0,0,0,0,2,2,3,4,6,8,10,13,19,19,19,19,19,27,39,39,0,0,
       0,0,0,0,0,0,0,0,3,3,4,5,7,10,13,17,25,25,25,25,25,34,49,49,0,0,
       0,0,0,0,0,0,0,0,3,3,4,6,8,11,15,20,29,29,29,29,29,40,58,58,0,0,
       0,0,0,0,0,0,0,0,3,3,5,6,9,12,17,23,33,33,33,33,33,47,68,68,0,0,
       0,0,0,0,0,0,0,0,3,3,5,7,10,14,19,26,38,38,38,38,38,54,78,78,0,0,
       0,0,0,0,0,0,0,2,2,2,3,4,4,5,7,9,9,9,9,9,9,12,16,16,0,0,
       0,0,0,0,0,0,0,2,2,3,3,5,6,8,10,14,14,14,14,14,14,19,27,27,0,0,
       0,0,0,0,0,0,0,2,2,3,4,6,8,10,13,19,19,19,19,19,19,27,39,39,0,0,
       0,0,0,0,0,0,0,3,3,4,5,7,10,13,17,25,25,25,25,25,25,34,49,49,0,0,
       0,0,0,0,0,0,0,3,3,4,6,8,11,15,20,29,29,29,29,29,29,40,58,58,0,0,
       0,0,0,0,0,0,0,3,3,5,6,9,12,17,23,33,33,33,33,33,33,47,68,68,0,0,
       0,0,0,0,0,0,0,3,3,5,7,10,14,19,26,38,38,38,38,38,38,54,78,78,0,0,
       0,0,0,0,0,0,2,2,2,3,4,4,5,7,9,9,9,9,9,9,9,12,16,16,0,0,
       0,0,0,0,0,0,2,2,3,3,5,6,8,10,14,14,14,14,14,14,14,19,27,27,0,0,
       0,0,0,0,0,0,2,2,3,4,6,8,10,13,19,19,19,19,19,19,19,27,39,39,0,0,
       0,0,0,0,0,0,3,3,4,5,7,10,13,17,25,25,25,25,25,25,25,34,49,49,0,0,
       0,0,0,0,0,0,3,3,4,6,8,11,15,20,29,29,29,29,29,29,29,40,58,58,0,0,
       0,0,0,0,0,0,3,3,5,6,9,12,17,23,33,33,33,33,33,33,33,47,68,68,0,0,
       0,0,0,0,0,0,3,3,5,7,10,14,19,26,38,38,38,38,38,38,38,54,78,78,0,0,
       0,0,0,0,0,2,2,2,3,4,4,5,7,9,9,9,9,9,9,9,9,12,16,16,0,0,
       0,0,0,0,0,2,2,3,3,5,6,8,10,14,14,14,14,14,14,14,14,19,27,27,0,0,
       0,0,0,0,0,2,2,3,4,6,8,10,13,19,19,19,19,19,19,19,19,27,39,39,0,0,
       0,0,0,0,0,3,3,4,5,7,10,13,17,25,25,25,25,25,25,25,25,34,49,49,0,0,
       0,0,0,0,0,3,3,4,6,8,11,15,20,29,29,29,29,29,29,29,29,40,58,58,0,0,
       0,0,0,0,0,3,3,5,6,9,12,17,23,33,33,33,33,33,33,33,33,47,68,68,0,0,
       0,0,0,0,0,3,3,5,7,10,14,19,26,38,38,38,38,38,38,38,38,54,78,78,0,0,
       0,0,0,0,2,2,2,3,4,4,5,7,9,9,9,9,9,9,9,9,9,12,16,16,0,0,
       0,0,0,0,2,2,3,3,5,6,8,10,14,14,14,14,14,14,14,14,14,19,27,27,0,0,
       0,0,0,0,2,2,3,4,6,8,10,13,19,19,19,19,19,19,19,19,19,27,39,39,0,0,
       0,0,0,0,3,3,4,5,7,10,13,17,25,25,25,25,25,25,25,25,25,34,49,49,0,0,
       0,0,0,0,3,3,4,6,8,11,15,20,29,29,29,29,29,29,29,29,29,40,58,58,0,0,
       0,0,0,0,3,3,5,6,9,12,17,23,33,33,33,33,33,33,33,33,33,47,68,68,0,0,
       0,0,0,0,3,3,5,7,10,14,19,26,38,38,38,38,38,38,38,38,38,54,78,78,0,0,
       0,0,0,2,2,2,3,4,4,5,7,9,9,9,9,9,9,9,9,9,9,12,16,16,0,0,
       0,0,0,2,2,3,3,5,6,8,10,14,14,14,14,14,14,14,14,14,14,19,27,27,0,0,
       0,0,0,2,2,3,4,6,8,10,13,19,19,19,19,19,19,19,19,19,19,27,39,39,0,0,
       0,0,0,3,3,4,5,7,10,13,17,25,25,25,25,25,25,25,25,25,25,34,49,49,0,0,
       0,0,0,3,3,4,6,8,11,15,20,29,29,29,29,29,29,29,29,29,29,40,58,58,0,0,
       0,0,0,3,3,5,6,9,12,17,23,33,33,33,33,33,33,33,33,33,33,47,68,68,0,0,
       0,0,0,3,3,5,7,10,14,19,26,38,38,38,38,38,38,38,38,38,38,54,78,78,0,0,
       0,0,2,2,2,3,4,4,5,7,9,9,9,9,9,9,9,9,9,9,9,12,16,16,0,0,
       0,0,2,2,3,3,5,6,8,10,14,14,14,14,14,14,14,14,14,14,14,19,27,27,0,0,
       0,0,2,2,3,4,6,8,10,13,19,19,19,19,19,19,19,19,19,19,19,27,39,39,0,0,
       0,0,3,3,4,5,7,10,13,17,25,25,25,25,25,25,25,25,25,25,25,34,49,49,0,0,
       0,0,3,3,4,6,8,11,15,20,29,29,29,29,29,29,29,29,29,29,29,40,58,58,0,0,
       0,0,3,3,5,6,9,12,17,23,33,33,33,33,33,33,33,33,33,33,33,47,68,68,0,0,
       0,0,3,3,5,7,10,14,19,26,38,38,38,38,38,38,38,38,38,38,38,54,78,78,0,0,
       0,0,2,2,3,4,4,5,7,9,9,9,9,9,9,9,9,9,9,9,9,12,16,16,0,0,
       0,0,2,3,3,5,6,8,10,14,14,14,14,14,14,14,14,14,14,14,14,19,27,27,0,0,
       0,0,2,3,4,6,8,10,13,19,19,19,19,19,19,19,19,19,19,19,19,27,39,39,0,0,
       0,0,3,4,5,7,10,13,17,25,25,25,25,25,25,25,25,25,25,25,25,34,49,49,0,0,
       0,0,3,4,6,8,11,15,20,29,29,29,29,29,29,29,29,29,29,29,29,40,58,58,0,0,
       0,0,3,5,6,9,12,17,23,33,33,33,33,33,33,33,33,33,33,33,33,47,68,68,0,0,
       0,0,3,5,7,10,14,19,26,38,38,38,38,38,38,38,38,38,38,38,38,54,78,78,0,0)
  AAMultipleNormalre<-array(t,  dim=c(26,7,16), dimnames=list(c("0.010","0.015","0.025","0.040","0.065","0.10","0.15","0.25","0.40","0.65","1.0","1.5","2.5","4.0","6.5",
                                                                 "10","15","25","40","65","100","150","250","400","650","1000"),
                                                               c("first","second","third","fourth","fifth","sixth","seventh"),
                                                               c("A","B","C","D","E","F","G","H","J","K","L","M","N","P","Q","R")
  ))
  # Create array of acceptance numbers for Multiple Tightened Sampling
  t<-c(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,3,4,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,4,6,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,0,0,1,3,6,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,0,0,1,2,3,6,10,16,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,4,7,11,17,26,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,6,10,16,24,37,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,5,9,14,22,32,49,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,3,4,7,12,18,27,40,61,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,4,6,9,14,21,32,48,72,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,0,0,1,3,6,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,0,0,1,2,3,6,10,16,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,4,7,11,17,26,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,6,10,16,24,37,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,3,5,9,14,22,32,49,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,3,4,7,12,18,27,40,61,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,4,6,9,14,21,32,48,72,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,0,0,1,3,6,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,0,0,1,2,3,6,10,16,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,4,7,11,17,26,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,6,10,16,24,37,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,3,5,9,14,22,32,49,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,3,4,7,12,18,27,40,61,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,4,6,9,14,21,32,48,72,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,0,0,1,3,6,6,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,0,0,1,2,3,6,10,16,16,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,4,7,11,17,26,26,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,6,10,16,24,37,37,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,3,5,9,14,22,32,49,49,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,3,4,7,12,18,27,40,61,61,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,4,6,9,14,21,32,48,72,72,0,0,
       0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,0,0,1,1,3,6,6,0,0,
       0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,0,0,1,2,3,6,6,10,16,16,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,4,7,11,11,17,26,26,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,6,10,16,16,24,37,37,0,0,
       0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,3,5,9,14,22,22,32,49,49,0,0,
       0,0,0,0,0,0,0,0,0,0,0,1,1,1,3,4,7,12,18,27,27,40,61,61,0,0,
       0,0,0,0,0,0,0,0,0,0,0,2,2,2,4,6,9,14,21,32,32,48,72,72,0,0,
       0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,0,0,1,1,1,3,6,6,0,0,
       0,0,0,0,0,0,0,0,0,0,-1,-1,-1,0,0,1,2,3,6,6,6,10,16,16,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,4,7,11,11,11,17,26,26,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,6,10,16,16,16,24,37,37,0,0,
       0,0,0,0,0,0,0,0,0,0,1,1,1,2,3,5,9,14,22,22,22,32,49,49,0,0,
       0,0,0,0,0,0,0,0,0,0,1,1,1,3,4,7,12,18,27,27,27,40,61,61,0,0,
       0,0,0,0,0,0,0,0,0,0,2,2,2,4,6,9,14,21,32,32,32,48,72,72,0,0,
       0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,0,0,1,1,1,1,3,6,6,0,0,
       0,0,0,0,0,0,0,0,0,-1,-1,-1,0,0,1,2,3,6,6,6,6,10,16,16,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,4,7,11,11,11,11,17,26,26,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,6,10,16,16,16,16,24,37,37,0,0,
       0,0,0,0,0,0,0,0,0,1,1,1,2,3,5,9,14,22,22,22,22,32,49,49,0,0,
       0,0,0,0,0,0,0,0,0,1,1,1,3,4,7,12,18,27,27,27,27,40,61,61,0,0,
       0,0,0,0,0,0,0,0,0,2,2,2,4,6,9,14,21,32,32,32,32,48,72,72,0,0,
       0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,0,0,1,1,1,1,1,3,6,6,0,0,
       0,0,0,0,0,0,0,0,-1,-1,-1,0,0,1,2,3,6,6,6,6,6,10,16,16,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,1,2,4,7,11,11,11,11,11,17,26,26,0,0,
       0,0,0,0,0,0,0,0,0,0,0,1,2,3,6,10,16,16,16,16,16,24,37,37,0,0,
       0,0,0,0,0,0,0,0,1,1,1,2,3,5,9,14,22,22,22,22,22,32,49,49,0,0,
       0,0,0,0,0,0,0,0,1,1,1,3,4,7,12,18,27,27,27,27,27,40,61,61,0,0,
       0,0,0,0,0,0,0,0,2,2,2,4,6,9,14,21,32,32,32,32,32,48,72,72,0,0,
       0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,0,0,1,1,1,1,1,1,3,6,6,0,0,
       0,0,0,0,0,0,0,-1,-1,-1,0,0,1,2,3,6,6,6,6,6,6,10,16,16,0,0,
       0,0,0,0,0,0,0,0,0,0,0,1,2,4,7,11,11,11,11,11,11,17,26,26,0,0,
       0,0,0,0,0,0,0,0,0,0,1,2,3,6,10,16,16,16,16,16,16,24,37,37,0,0,
       0,0,0,0,0,0,0,1,1,1,2,3,5,9,14,22,22,22,22,22,22,32,49,49,0,0,
       0,0,0,0,0,0,0,1,1,1,3,4,7,12,18,27,27,27,27,27,27,40,61,61,0,0,
       0,0,0,0,0,0,0,2,2,2,4,6,9,14,21,32,32,32,32,32,32,48,72,72,0,0,
       0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,0,0,1,1,1,1,1,1,1,3,6,6,0,0,
       0,0,0,0,0,0,-1,-1,-1,0,0,1,2,3,6,6,6,6,6,6,6,10,16,16,0,0,
       0,0,0,0,0,0,0,0,0,0,1,2,4,7,11,11,11,11,11,11,11,17,26,26,0,0,
       0,0,0,0,0,0,0,0,0,1,2,3,6,10,16,16,16,16,16,16,16,24,37,37,0,0,
       0,0,0,0,0,0,1,1,1,2,3,5,9,14,22,22,22,22,22,22,22,32,49,49,0,0,
       0,0,0,0,0,0,1,1,1,3,4,7,12,18,27,27,27,27,27,27,27,40,61,61,0,0,
       0,0,0,0,0,0,2,2,2,4,6,9,14,21,32,32,32,32,32,32,32,48,72,72,0,0,
       0,0,0,0,0,-1,-1,-1,-1,-1,-1,0,0,1,1,1,1,1,1,1,1,3,6,6,0,0,
       0,0,0,0,0,-1,-1,-1,0,0,1,2,3,6,6,6,6,6,6,6,6,10,16,16,0,0,
       0,0,0,0,0,0,0,0,0,1,2,4,7,11,11,11,11,11,11,11,11,17,26,26,0,0,
       0,0,0,0,0,0,0,0,1,2,3,6,10,16,16,16,16,16,16,16,16,24,37,37,0,0,
       0,0,0,0,0,1,1,1,2,3,5,9,14,22,22,22,22,22,22,22,22,32,49,49,0,0,
       0,0,0,0,0,1,1,1,3,4,7,12,18,27,27,27,27,27,27,27,27,40,61,61,0,0,
       0,0,0,0,0,2,2,2,4,6,9,14,21,32,32,32,32,32,32,32,32,48,72,72,0,0,
       0,0,0,0,-1,-1,-1,-1,-1,-1,0,0,1,1,1,1,1,1,1,1,1,3,6,6,0,0,
       0,0,0,0,-1,-1,-1,0,0,1,2,3,6,6,6,6,6,6,6,6,6,10,16,16,0,0,
       0,0,0,0,0,0,0,0,1,2,4,7,11,11,11,11,11,11,11,11,11,17,26,26,0,0,
       0,0,0,0,0,0,0,1,2,3,6,10,16,16,16,16,16,16,16,16,16,24,37,37,0,0,
       0,0,0,0,1,1,1,2,3,5,9,14,22,22,22,22,22,22,22,22,22,32,49,49,0,0,
       0,0,0,0,1,1,1,3,4,7,12,18,27,27,27,27,27,27,27,27,27,40,61,61,0,0,
       0,0,0,0,2,2,2,4,6,9,14,21,32,32,32,32,32,32,32,32,32,48,72,72,0,0,
       0,0,0,-1,-1,-1,-1,-1,-1,0,0,1,1,1,1,1,1,1,1,1,1,3,6,6,0,0,
       0,0,0,-1,-1,-1,0,0,1,2,3,6,6,6,6,6,6,6,6,6,6,10,16,16,0,0,
       0,0,0,0,0,0,0,1,2,4,7,11,11,11,11,11,11,11,11,11,11,17,26,26,0,0,
       0,0,0,0,0,0,1,2,3,6,10,16,16,16,16,16,16,16,16,16,16,24,37,37,0,0,
       0,0,0,1,1,1,2,3,5,9,14,22,22,22,22,22,22,22,22,22,22,32,49,49,0,0,
       0,0,0,1,1,1,3,4,7,12,18,27,27,27,27,27,27,27,27,27,27,40,61,61,0,0,
       0,0,0,2,2,2,4,6,9,14,21,32,32,32,32,32,32,32,32,32,32,48,72,72,0,0,
       0,0,-1,-1,-1,-1,-1,-1,0,0,1,1,1,1,1,1,1,1,1,1,1,3,6,6,0,0,
       0,0,-1,-1,-1,0,0,1,2,3,6,6,6,6,6,6,6,6,6,6,6,10,16,16,0,0,
       0,0,0,0,0,0,1,2,4,7,11,11,11,11,11,11,11,11,11,11,11,17,26,26,0,0,
       0,0,0,0,0,1,2,3,6,10,16,16,16,16,16,16,16,16,16,16,16,24,37,37,0,0,
       0,0,1,1,1,2,3,5,9,14,22,22,22,22,22,22,22,22,22,22,22,32,49,49,0,0,
       0,0,1,1,1,3,4,7,12,18,27,27,27,27,27,27,27,27,27,27,27,40,61,61,0,0,
       0,0,2,2,2,4,6,9,14,21,32,32,32,32,32,32,32,32,32,32,32,48,72,72,0,0,
       0,0,-1,-1,-1,-1,-1,0,0,1,1,1,1,1,1,1,1,1,1,1,1,3,6,6,0,0,
       0,0,-1,-1,0,0,1,2,3,6,6,6,6,6,6,6,6,6,6,6,6,10,16,16,0,0,
       0,0,0,0,0,1,2,4,7,11,11,11,11,11,11,11,11,11,11,11,11,17,26,26,0,0,
       0,0,0,0,1,2,3,6,10,16,16,16,16,16,16,16,16,16,16,16,16,24,37,37,0,0,
       0,0,1,1,2,3,5,9,14,22,22,22,22,22,22,22,22,22,22,22,22,32,49,49,0,0,
       0,0,1,1,3,4,7,12,18,27,27,27,27,27,27,27,27,27,27,27,27,40,61,61,0,0,
       0,0,2,2,4,6,9,14,21,32,32,32,32,32,32,32,32,32,32,32,32,48,72,72,0,0)
  AAMultipleTightenedac<-array(t, dim=c(26,7,16), dimnames=list(c("0.010","0.015","0.025","0.040","0.065","0.10","0.15","0.25","0.40","0.65","1.0","1.5","2.5","4.0","6.5",
                                                                  "10","15","25","40","65","100","150","250","400","650","1000"),
                                                                c("first","second","third","fourth","fifth","sixth","seventh"),
                                                                c("A","B","C","D","E","F","G","H","J","K","L","M","N","P","Q","R")
  ))
  # Create array of rejection numbers for Multiple Tightened Sampling
  t<-c(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,3,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,4,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,4,5,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,4,6,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,5,6,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,5,7,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,4,4,6,8,10,15,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,3,5,7,9,12,17,25,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,4,6,9,12,17,24,36,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,4,5,7,11,15,22,31,46,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,4,6,8,12,17,25,37,55,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,5,6,9,14,20,29,43,64,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,5,7,10,15,22,33,49,73,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,4,4,6,8,10,15,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,3,3,5,7,9,12,17,25,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,3,4,6,9,12,17,24,36,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,4,5,7,11,15,22,31,46,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,4,6,8,12,17,25,37,55,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,5,6,9,14,20,29,43,64,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,5,7,10,15,22,33,49,73,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,4,4,6,8,10,15,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,3,3,5,7,9,12,17,25,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,3,4,6,9,12,17,24,36,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,4,5,7,11,15,22,31,46,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,4,6,8,12,17,25,37,55,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,5,6,9,14,20,29,43,64,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,5,7,10,15,22,33,49,73,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,4,4,6,8,10,15,15,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,3,3,5,7,9,12,17,25,25,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,2,2,2,3,4,6,9,12,17,24,36,36,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,4,5,7,11,15,22,31,46,46,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,4,6,8,12,17,25,37,55,55,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,5,6,9,14,20,29,43,64,64,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,5,7,10,15,22,33,49,73,73,0,0,
       0,0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,4,4,6,8,8,10,15,15,0,0,
       0,0,0,0,0,0,0,0,0,0,0,2,2,2,3,3,5,7,9,12,12,17,25,25,0,0,
       0,0,0,0,0,0,0,0,0,0,0,2,2,2,3,4,6,9,12,17,17,24,36,36,0,0,
       0,0,0,0,0,0,0,0,0,0,0,3,3,3,4,5,7,11,15,22,22,31,46,46,0,0,
       0,0,0,0,0,0,0,0,0,0,0,3,3,3,4,6,8,12,17,25,25,37,55,55,0,0,
       0,0,0,0,0,0,0,0,0,0,0,3,3,3,5,6,9,14,20,29,29,43,64,64,0,0,
       0,0,0,0,0,0,0,0,0,0,0,3,3,3,5,7,10,15,22,33,33,49,73,73,0,0,
       0,0,0,0,0,0,0,0,0,0,2,2,2,2,2,4,4,6,8,8,8,10,15,15,0,0,
       0,0,0,0,0,0,0,0,0,0,2,2,2,3,3,5,7,9,12,12,12,17,25,25,0,0,
       0,0,0,0,0,0,0,0,0,0,2,2,2,3,4,6,9,12,17,17,17,24,36,36,0,0,
       0,0,0,0,0,0,0,0,0,0,3,3,3,4,5,7,11,15,22,22,22,31,46,46,0,0,
       0,0,0,0,0,0,0,0,0,0,3,3,3,4,6,8,12,17,25,25,25,37,55,55,0,0,
       0,0,0,0,0,0,0,0,0,0,3,3,3,5,6,9,14,20,29,29,29,43,64,64,0,0,
       0,0,0,0,0,0,0,0,0,0,3,3,3,5,7,10,15,22,33,33,33,49,73,73,0,0,
       0,0,0,0,0,0,0,0,0,2,2,2,2,2,4,4,6,8,8,8,8,10,15,15,0,0,
       0,0,0,0,0,0,0,0,0,2,2,2,3,3,5,7,9,12,12,12,12,17,25,25,0,0,
       0,0,0,0,0,0,0,0,0,2,2,2,3,4,6,9,12,17,17,17,17,24,36,36,0,0,
       0,0,0,0,0,0,0,0,0,3,3,3,4,5,7,11,15,22,22,22,22,31,46,46,0,0,
       0,0,0,0,0,0,0,0,0,3,3,3,4,6,8,12,17,25,25,25,25,37,55,55,0,0,
       0,0,0,0,0,0,0,0,0,3,3,3,5,6,9,14,20,29,29,29,29,43,64,64,0,0,
       0,0,0,0,0,0,0,0,0,3,3,3,5,7,10,15,22,33,33,33,33,49,73,73,0,0,
       0,0,0,0,0,0,0,0,2,2,2,2,2,4,4,6,8,8,8,8,8,10,15,15,0,0,
       0,0,0,0,0,0,0,0,2,2,2,3,3,5,7,9,12,12,12,12,12,17,25,25,0,0,
       0,0,0,0,0,0,0,0,2,2,2,3,4,6,9,12,17,17,17,17,17,24,36,36,0,0,
       0,0,0,0,0,0,0,0,3,3,3,4,5,7,11,15,22,22,22,22,22,31,46,46,0,0,
       0,0,0,0,0,0,0,0,3,3,3,4,6,8,12,17,25,25,25,25,25,37,55,55,0,0,
       0,0,0,0,0,0,0,0,3,3,3,5,6,9,14,20,29,29,29,29,29,43,64,64,0,0,
       0,0,0,0,0,0,0,0,3,3,3,5,7,10,15,22,33,33,33,33,33,49,73,73,0,0,
       0,0,0,0,0,0,0,2,2,2,2,2,4,4,6,8,8,8,8,8,8,10,15,15,0,0,
       0,0,0,0,0,0,0,2,2,2,3,3,5,7,9,12,12,12,12,12,12,17,25,25,0,0,
       0,0,0,0,0,0,0,2,2,2,3,4,6,9,12,17,17,17,17,17,17,24,36,36,0,0,
       0,0,0,0,0,0,0,3,3,3,4,5,7,11,15,22,22,22,22,22,22,31,46,46,0,0,
       0,0,0,0,0,0,0,3,3,3,4,6,8,12,17,25,25,25,25,25,25,37,55,55,0,0,
       0,0,0,0,0,0,0,3,3,3,5,6,9,14,20,29,29,29,29,29,29,43,64,64,0,0,
       0,0,0,0,0,0,0,3,3,3,5,7,10,15,22,33,33,33,33,33,33,49,73,73,0,0,
       0,0,0,0,0,0,2,2,2,2,2,4,4,6,8,8,8,8,8,8,8,10,15,15,0,0,
       0,0,0,0,0,0,2,2,2,3,3,5,7,9,12,12,12,12,12,12,12,17,25,25,0,0,
       0,0,0,0,0,0,2,2,2,3,4,6,9,12,17,17,17,17,17,17,17,24,36,36,0,0,
       0,0,0,0,0,0,3,3,3,4,5,7,11,15,22,22,22,22,22,22,22,31,46,46,0,0,
       0,0,0,0,0,0,3,3,3,4,6,8,12,17,25,25,25,25,25,25,25,37,55,55,0,0,
       0,0,0,0,0,0,3,3,3,5,6,9,14,20,29,29,29,29,29,29,29,43,64,64,0,0,
       0,0,0,0,0,0,3,3,3,5,7,10,15,22,33,33,33,33,33,33,33,49,73,73,0,0,
       0,0,0,0,0,2,2,2,2,2,4,4,6,8,8,8,8,8,8,8,8,10,15,15,0,0,
       0,0,0,0,0,2,2,2,3,3,5,7,9,12,12,12,12,12,12,12,12,17,25,25,0,0,
       0,0,0,0,0,2,2,2,3,4,6,9,12,17,17,17,17,17,17,17,17,24,36,36,0,0,
       0,0,0,0,0,3,3,3,4,5,7,11,15,22,22,22,22,22,22,22,22,31,46,46,0,0,
       0,0,0,0,0,3,3,3,4,6,8,12,17,25,25,25,25,25,25,25,25,37,55,55,0,0,
       0,0,0,0,0,3,3,3,5,6,9,14,20,29,29,29,29,29,29,29,29,43,64,64,0,0,
       0,0,0,0,0,3,3,3,5,7,10,15,22,33,33,33,33,33,33,33,33,49,73,73,0,0,
       0,0,0,0,2,2,2,2,2,4,4,6,8,8,8,8,8,8,8,8,8,10,15,15,0,0,
       0,0,0,0,2,2,2,3,3,5,7,9,12,12,12,12,12,12,12,12,12,17,25,25,0,0,
       0,0,0,0,2,2,2,3,4,6,9,12,17,17,17,17,17,17,17,17,17,24,36,36,0,0,
       0,0,0,0,3,3,3,4,5,7,11,15,22,22,22,22,22,22,22,22,22,31,46,46,0,0,
       0,0,0,0,3,3,3,4,6,8,12,17,25,25,25,25,25,25,25,25,25,37,55,55,0,0,
       0,0,0,0,3,3,3,5,6,9,14,20,29,29,29,29,29,29,29,29,29,43,64,64,0,0,
       0,0,0,0,3,3,3,5,7,10,15,22,33,33,33,33,33,33,33,33,33,49,73,73,0,0,
       0,0,0,2,2,2,2,2,4,4,6,8,8,8,8,8,8,8,8,8,8,10,15,15,0,0,
       0,0,0,2,2,2,3,3,5,7,9,12,12,12,12,12,12,12,12,12,12,17,25,25,0,0,
       0,0,0,2,2,2,3,4,6,9,12,17,17,17,17,17,17,17,17,17,17,24,36,36,0,0,
       0,0,0,3,3,3,4,5,7,11,15,22,22,22,22,22,22,22,22,22,22,31,46,46,0,0,
       0,0,0,3,3,3,4,6,8,12,17,25,25,25,25,25,25,25,25,25,25,37,55,55,0,0,
       0,0,0,3,3,3,5,6,9,14,20,29,29,29,29,29,29,29,29,29,29,43,64,64,0,0,
       0,0,0,3,3,3,5,7,10,15,22,33,33,33,33,33,33,33,33,33,33,49,73,73,0,0,
       0,0,2,2,2,2,2,4,4,6,8,8,8,8,8,8,8,8,8,8,8,10,15,15,0,0,
       0,0,2,2,2,3,3,5,7,9,12,12,12,12,12,12,12,12,12,12,12,17,25,25,0,0,
       0,0,2,2,2,3,4,6,9,12,17,17,17,17,17,17,17,17,17,17,17,24,36,36,0,0,
       0,0,3,3,3,4,5,7,11,15,22,22,22,22,22,22,22,22,22,22,22,31,46,46,0,0,
       0,0,3,3,3,4,6,8,12,17,25,25,25,25,25,25,25,25,25,25,25,37,55,55,0,0,
       0,0,3,3,3,5,6,9,14,20,29,29,29,29,29,29,29,29,29,29,29,43,64,64,0,0,
       0,0,3,3,3,5,7,10,15,22,33,33,33,33,33,33,33,33,33,33,33,49,73,73,0,0,
       0,0,2,2,2,2,4,4,6,8,8,8,8,8,8,8,8,8,8,8,8,10,15,15,0,0,
       0,0,2,2,3,3,5,7,9,12,12,12,12,12,12,12,12,12,12,12,12,17,25,25,0,0,
       0,0,2,2,3,4,6,9,12,17,17,17,17,17,17,17,17,17,17,17,17,24,36,36,0,0,
       0,0,3,3,4,5,7,11,15,22,22,22,22,22,22,22,22,22,22,22,22,31,46,46,0,0,
       0,0,3,3,4,6,8,12,17,25,25,25,25,25,25,25,25,25,25,25,25,37,55,55,0,0,
       0,0,3,3,5,6,9,14,20,29,29,29,29,29,29,29,29,29,29,29,29,43,64,64,0,0,
       0,0,3,3,5,7,10,15,22,33,33,33,33,33,33,33,33,33,33,33,33,49,73,73,0,0)
  AAMultipleTightenedre<-array(t,  dim=c(26,7,16), dimnames=list(c("0.010","0.015","0.025","0.040","0.065","0.10","0.15","0.25","0.40","0.65","1.0","1.5","2.5","4.0","6.5",
                                                                   "10","15","25","40","65","100","150","250","400","650","1000"),
                                                                 c("first","second","third","fourth","fifth","sixth","seventh"),
                                                                 c("A","B","C","D","E","F","G","H","J","K","L","M","N","P","Q","R")
  ))
  # Create array of acceptance numbers for Multiple Reduced Sampling
  t<-c(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,-1,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,-1,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,0,0,1,1,3,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,6,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,5,8,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,5,7,11,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,3,4,7,10,14,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,4,6,9,13,18,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,0,0,1,1,3,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,6,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,5,8,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,5,7,11,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,3,4,7,10,14,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,1,1,1,2,4,6,9,13,18,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,0,0,1,1,3,3,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,6,6,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,5,8,8,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,5,7,11,11,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,1,1,3,4,7,10,14,14,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,1,1,1,2,4,6,9,13,18,18,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,-1,-1,-1,-1,0,0,1,1,3,3,3,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,6,6,6,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,5,8,8,8,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,5,7,11,11,11,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,1,1,3,4,7,10,14,14,14,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,1,1,1,2,4,6,9,13,18,18,18,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,-1,-1,-1,-1,0,0,1,1,3,3,3,3,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,6,6,6,6,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,5,8,8,8,8,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,1,2,3,5,7,11,11,11,11,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,1,1,3,4,7,10,14,14,14,14,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,1,1,1,2,4,6,9,13,18,18,18,18,0,0,0,0,0,0,
       0,0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,-1,-1,-1,-1,0,0,1,1,3,3,3,3,3,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,6,6,6,6,6,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,1,2,3,5,8,8,8,8,8,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,1,2,3,5,7,11,11,11,11,11,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,1,1,3,4,7,10,14,14,14,14,14,0,0,0,0,0,0,
       0,0,0,0,0,0,0,1,1,1,2,4,6,9,13,18,18,18,18,18,0,0,0,0,0,0,
       0,0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,-1,-1,-1,-1,0,0,1,1,3,3,3,3,3,3,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,1,2,3,6,6,6,6,6,6,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,1,2,3,5,8,8,8,8,8,8,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,1,2,3,5,7,11,11,11,11,11,11,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,1,1,3,4,7,10,14,14,14,14,14,14,0,0,0,0,0,0,
       0,0,0,0,0,0,1,1,1,2,4,6,9,13,18,18,18,18,18,18,0,0,0,0,0,0,
       0,0,0,0,0,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,-1,-1,-1,-1,0,0,1,1,3,3,3,3,3,3,3,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,1,2,3,6,6,6,6,6,6,6,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,1,2,3,5,8,8,8,8,8,8,8,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,1,2,3,5,7,11,11,11,11,11,11,11,0,0,0,0,0,0,
       0,0,0,0,0,0,0,1,1,3,4,7,10,14,14,14,14,14,14,14,0,0,0,0,0,0,
       0,0,0,0,0,1,1,1,2,4,6,9,13,18,18,18,18,18,18,18,0,0,0,0,0,0,
       0,0,0,0,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,-1,-1,-1,-1,0,0,1,1,3,3,3,3,3,3,3,3,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,1,2,3,6,6,6,6,6,6,6,6,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,1,2,3,5,8,8,8,8,8,8,8,8,0,0,0,0,0,0,
       0,0,0,0,0,0,0,1,2,3,5,7,11,11,11,11,11,11,11,11,0,0,0,0,0,0,
       0,0,0,0,0,0,1,1,3,4,7,10,14,14,14,14,14,14,14,14,0,0,0,0,0,0,
       0,0,0,0,1,1,1,2,4,6,9,13,18,18,18,18,18,18,18,18,0,0,0,0,0,0,
       0,0,0,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,-1,-1,-1,-1,0,0,1,1,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,1,2,3,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,
       0,0,0,0,0,0,0,1,2,3,5,8,8,8,8,8,8,8,8,8,0,0,0,0,0,0,
       0,0,0,0,0,0,1,2,3,5,7,11,11,11,11,11,11,11,11,11,0,0,0,0,0,0,
       0,0,0,0,0,1,1,3,4,7,10,14,14,14,14,14,14,14,14,14,0,0,0,0,0,0,
       0,0,0,1,1,1,2,4,6,9,13,18,18,18,18,18,18,18,18,18,0,0,0,0,0,0,
       0,0,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,-1,-1,-1,-1,0,0,1,1,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,
       0,0,0,0,0,0,0,1,2,3,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,
       0,0,0,0,0,0,1,2,3,5,8,8,8,8,8,8,8,8,8,8,0,0,0,0,0,0,
       0,0,0,0,0,1,2,3,5,7,11,11,11,11,11,11,11,11,11,11,0,0,0,0,0,0,
       0,0,0,0,1,1,3,4,7,10,14,14,14,14,14,14,14,14,14,14,0,0,0,0,0,0,
       0,0,1,1,1,2,4,6,9,13,18,18,18,18,18,18,18,18,18,18,0,0,0,0,0,0,
       0,0,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,-1,-1,-1,0,0,1,1,3,3,3,3,3,3,3,3,3,3,3,0,0,0,0,0,0,
       0,0,0,0,0,0,1,2,3,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,
       0,0,0,0,0,1,2,3,5,8,8,8,8,8,8,8,8,8,8,8,0,0,0,0,0,0,
       0,0,0,0,1,2,3,5,7,11,11,11,11,11,11,11,11,11,11,11,0,0,0,0,0,0,
       0,0,0,1,1,3,4,7,10,14,14,14,14,14,14,14,14,14,14,14,0,0,0,0,0,0,
       0,0,1,1,2,4,6,9,13,18,18,18,18,18,18,18,18,18,18,18,0,0,0,0,0,0)
  AAMultipleReducedac<-array(t,  dim=c(26,7,16), dimnames=list(c("0.010","0.015","0.025","0.040","0.065","0.10","0.15","0.25","0.40","0.65","1.0","1.5","2.5","4.0","6.5",
                                                                 "10","15","25","40","65","100","150","250","400","650","1000"),
                                                               c("first","second","third","fourth","fifth","sixth","seventh"),
                                                               c("A","B","C","D","E","F","G","H","J","K","L","M","N","P","Q","R")
  ))
  # Create array of rejection numbers for Multiple Reduced Sampling
  t<-c(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,2,2,3,3,4,4,5,6,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,2,2,3,4,5,6,7,9,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,2,2,4,5,6,8,9,12,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,3,3,5,6,7,10,12,15,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,3,3,6,7,8,11,13,17,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,3,3,6,7,9,12,15,20,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,0,3,3,7,8,10,14,17,22,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,2,2,2,3,3,4,4,5,6,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,2,2,3,3,4,5,6,7,9,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,2,2,3,4,5,6,8,9,12,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,3,3,4,5,6,7,10,12,15,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,3,3,4,6,7,8,11,13,17,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,3,3,5,6,7,9,12,15,20,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,0,3,3,5,7,8,10,14,17,22,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,2,2,2,3,3,4,4,5,6,6,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,2,2,3,3,4,5,6,7,9,9,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,2,2,3,4,5,6,8,9,12,12,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,3,3,4,5,6,7,10,12,15,15,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,3,3,4,6,7,8,11,13,17,17,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,3,3,5,6,7,9,12,15,20,20,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,0,3,3,5,7,8,10,14,17,22,22,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,2,2,2,3,3,4,4,5,6,6,6,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,2,2,3,3,4,5,6,7,9,9,9,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,2,2,3,4,5,6,8,9,12,12,12,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,3,3,4,5,6,7,10,12,15,15,15,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,3,3,4,6,7,8,11,13,17,17,17,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,3,3,5,6,7,9,12,15,20,20,20,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,0,3,3,5,7,8,10,14,17,22,22,22,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,2,2,2,3,3,4,4,5,6,6,6,6,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,2,2,3,3,4,5,6,7,9,9,9,9,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,2,2,3,4,5,6,8,9,12,12,12,12,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,3,3,4,5,6,7,10,12,15,15,15,15,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,3,3,4,6,7,8,11,13,17,17,17,17,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,3,3,5,6,7,9,12,15,20,20,20,20,0,0,0,0,0,0,
       0,0,0,0,0,0,0,0,3,3,5,7,8,10,14,17,22,22,22,22,0,0,0,0,0,0,
       0,0,0,0,0,0,0,2,2,2,3,3,4,4,5,6,6,6,6,6,0,0,0,0,0,0,
       0,0,0,0,0,0,0,2,2,3,3,4,5,6,7,9,9,9,9,9,0,0,0,0,0,0,
       0,0,0,0,0,0,0,2,2,3,4,5,6,8,9,12,12,12,12,12,0,0,0,0,0,0,
       0,0,0,0,0,0,0,3,3,4,5,6,7,10,12,15,15,15,15,15,0,0,0,0,0,0,
       0,0,0,0,0,0,0,3,3,4,6,7,8,11,13,17,17,17,17,17,0,0,0,0,0,0,
       0,0,0,0,0,0,0,3,3,5,6,7,9,12,15,20,20,20,20,20,0,0,0,0,0,0,
       0,0,0,0,0,0,0,3,3,5,7,8,10,14,17,22,22,22,22,22,0,0,0,0,0,0,
       0,0,0,0,0,0,2,2,2,3,3,4,4,5,6,6,6,6,6,6,0,0,0,0,0,0,
       0,0,0,0,0,0,2,2,3,3,4,5,6,7,9,9,9,9,9,9,0,0,0,0,0,0,
       0,0,0,0,0,0,2,2,3,4,5,6,8,9,12,12,12,12,12,12,0,0,0,0,0,0,
       0,0,0,0,0,0,3,3,4,5,6,7,10,12,15,15,15,15,15,15,0,0,0,0,0,0,
       0,0,0,0,0,0,3,3,4,6,7,8,11,13,17,17,17,17,17,17,0,0,0,0,0,0,
       0,0,0,0,0,0,3,3,5,6,7,9,12,15,20,20,20,20,20,20,0,0,0,0,0,0,
       0,0,0,0,0,0,3,3,5,7,8,10,14,17,22,22,22,22,22,22,0,0,0,0,0,0,
       0,0,0,0,0,2,2,2,3,3,4,4,5,6,6,6,6,6,6,6,0,0,0,0,0,0,
       0,0,0,0,0,2,2,3,3,4,5,6,7,9,9,9,9,9,9,9,0,0,0,0,0,0,
       0,0,0,0,0,2,2,3,4,5,6,8,9,12,12,12,12,12,12,12,0,0,0,0,0,0,
       0,0,0,0,0,3,3,4,5,6,7,10,12,15,15,15,15,15,15,15,0,0,0,0,0,0,
       0,0,0,0,0,3,3,4,6,7,8,11,13,17,17,17,17,17,17,17,0,0,0,0,0,0,
       0,0,0,0,0,3,3,5,6,7,9,12,15,20,20,20,20,20,20,20,0,0,0,0,0,0,
       0,0,0,0,0,3,3,5,7,8,10,14,17,22,22,22,22,22,22,22,0,0,0,0,0,0,
       0,0,0,0,2,2,2,3,3,4,4,5,6,6,6,6,6,6,6,6,0,0,0,0,0,0,
       0,0,0,0,2,2,3,3,4,5,6,7,9,9,9,9,9,9,9,9,0,0,0,0,0,0,
       0,0,0,0,2,2,3,4,5,6,8,9,12,12,12,12,12,12,12,12,0,0,0,0,0,0,
       0,0,0,0,3,3,4,5,6,7,10,12,15,15,15,15,15,15,15,15,0,0,0,0,0,0,
       0,0,0,0,3,3,4,6,7,8,11,13,17,17,17,17,17,17,17,17,0,0,0,0,0,0,
       0,0,0,0,3,3,5,6,7,9,12,15,20,20,20,20,20,20,20,20,0,0,0,0,0,0,
       0,0,0,0,3,3,5,7,8,10,14,17,22,22,22,22,22,22,22,22,0,0,0,0,0,0,
       0,0,0,2,2,2,3,3,4,4,5,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,
       0,0,0,2,2,3,3,4,5,6,7,9,9,9,9,9,9,9,9,9,0,0,0,0,0,0,
       0,0,0,2,2,3,4,5,6,8,9,12,12,12,12,12,12,12,12,12,0,0,0,0,0,0,
       0,0,0,3,3,4,5,6,7,10,12,15,15,15,15,15,15,15,15,15,0,0,0,0,0,0,
       0,0,0,3,3,4,6,7,8,11,13,17,17,17,17,17,17,17,17,17,0,0,0,0,0,0,
       0,0,0,3,3,5,6,7,9,12,15,20,20,20,20,20,20,20,20,20,0,0,0,0,0,0,
       0,0,0,3,3,5,7,8,10,14,17,22,22,22,22,22,22,22,22,22,0,0,0,0,0,0,
       0,0,2,2,2,3,3,4,4,5,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,
       0,0,2,2,3,3,4,5,6,7,9,9,9,9,9,9,9,9,9,9,0,0,0,0,0,0,
       0,0,2,2,3,4,5,6,8,9,12,12,12,12,12,12,12,12,12,12,0,0,0,0,0,0,
       0,0,3,3,4,5,6,7,10,12,15,15,15,15,15,15,15,15,15,15,0,0,0,0,0,0,
       0,0,3,3,4,6,7,8,11,13,17,17,17,17,17,17,17,17,17,17,0,0,0,0,0,0,
       0,0,3,3,5,6,7,9,12,15,20,20,20,20,20,20,20,20,20,20,0,0,0,0,0,0,
       0,0,3,3,5,7,8,10,14,17,22,22,22,22,22,22,22,22,22,22,0,0,0,0,0,0,
       0,0,2,2,3,3,4,4,5,6,6,6,6,6,6,6,6,6,6,6,0,0,0,0,0,0,
       0,0,2,3,3,4,5,6,7,9,9,9,9,9,9,9,9,9,9,9,0,0,0,0,0,0,
       0,0,2,3,4,5,6,8,9,12,12,12,12,12,12,12,12,12,12,12,0,0,0,0,0,0,
       0,0,3,4,5,6,7,10,12,15,15,15,15,15,15,15,15,15,15,15,0,0,0,0,0,0,
       0,0,3,4,6,7,8,11,13,17,17,17,17,17,17,17,17,17,17,17,0,0,0,0,0,0,
       0,0,3,5,6,7,9,12,15,20,20,20,20,20,20,20,20,20,20,20,0,0,0,0,0,0,
       0,0,3,5,7,8,10,14,17,22,22,22,22,22,22,22,22,22,22,22,0,0,0,0,0,0)
  AAMultipleReducedre<-array(t,  dim=c(26,7,16), dimnames=list(c("0.010","0.015","0.025","0.040","0.065","0.10","0.15","0.25","0.40","0.65","1.0","1.5","2.5","4.0","6.5",
                                                                 "10","15","25","40","65","100","150","250","400","650","1000"),
                                                               c("first","second","third","fourth","fifth","sixth","seventh"),
                                                               c("A","B","C","D","E","F","G","H","J","K","L","M","N","P","Q","R")
  ))
  # Get Code letter from SSCodeLetters
  codelet<-SSCodeLetters[dLOTS,dINSL]
  if(PLAN == 1) {
    ac<-AAMultipleNormalac[dAQL, ,codelet]
    re<-AAMultipleNormalre[dAQL, ,codelet]
    S<-AAMultipleNormalss[codelet, dAQL]
    ss<-c(S,S,S,S,S,S,S)
    names(ss)<-c("first","second","third","fourth","fifth","sixth","seventh")
  } else if(PLAN == 2) {
    ac<-AAMultipleTightenedac[dAQL,  ,codelet]
    re<-AAMultipleTightenedre[dAQL, ,codelet]
    S<-AAMultipleTightenedss[codelet, dAQL]
    ss<-c(S,S,S,S,S,S,S)
    names(ss)<-c("first","second","third","fourth","fifth","sixth","seventh")
  } else if(PLAN == 3) {
    ac<-AAMultipleReducedac[dAQL,  ,codelet]
    re<-AAMultipleReducedre[dAQL, ,codelet]
    S<-AAMultipleReducedss[codelet, dAQL ]
    ss<-c(S,S,S,S,S,S,S)
    names(ss)<-c("first","second","third","fourth","fifth","sixth","seventh")
  }
  if(S==-1) {warning("No multiple sampling exists. Use the corresponding single sampling plan")
  } else if(S==-2) {warning("No multiple sampling exists. Use the corresponding double sampling plan")
  } else if(S>0) {plan<-data.frame(n=ss,c=ac,r=re)
  return(plan)
}
}
