AAZ14Double<-function(PLAN,INSL,LOTS,AQL){
  message("MIL-STD-105E ANSI/ASQ Z1.4")
  # Get the inspection level
  dINSL <- menu(c("S-1", "S-2", "S-3", "S-4",
                  "I", "II", "III"), title = "\nWhat is the Inspection Level?")
  INSL
  # Get the lot size
  dLOTS <- menu(c("2-8", "9-15", "16-25", "26-50",
                  "51-90", "91-150", "151-280", "281-500",
                  "501-1200", "1201-3200", "3201-10,000",
                  "10,001-35,000", "35,001-150,000", "150,001-500,000",
                  "500,001 and over"), title = "\nWhat is the Lot Size?")
  LOTS
  # Get the AQL
  dAQL <- menu(c("0.010","0.015","0.025","0.040","0.065","0.10","0.15","0.25",
                 "0.40","0.65","1.0","1.5","2.5","4.0","6.5","10",
                 "15","25","40","65","100","150","250","400","650","1000"),
               title = "\nWhat is the AQL in percent nonconforming per 100 items?")
  AQL

#Create matrix of Code Letters
codes<-c("A","B","C","D","E","F","G","H","J","K","L","M","N","P","Q","R")
InspLev<-c("S-1","S-2","S-3","S-4","I","II","III")
LotSize<-c("2-8","9-15","16-25","26-50","51-90","91-150","151-280","281-500","501-1200","1201-3200","3201-10,000","10,001-35,000","35,001-150,000","150,001-500,000","over 500,001")
AQL<-c("0.010","0.015","0.025","0.040","0.065","0.10","0.15","0.25","0.40","0.65","1.0","1.5","2.5","4.0","6.5","10","15","25","40","65","100","150","250","400","650","1000")
letters<-c("A","A","A","A","A","A","B",
          "A","A","A","A","A","B","C",
          "A","A","B","B","B","C","D",
          "A","B","B","C","C","D","E",
          "B","B","C","C","C","E","F",
          "B","B","C","D","D","F","G",
          "B","C","D","E","E","G","H",
          "B","C","D","E","F","H","J",
          "C","C","E","F","G","J","K",
          "C","D","E","G","H","K","L",
          "C","D","F","G","J","L","M",
          "C","D","F","H","K","M","N",
          "D","E","G","J","L","N","P",
          "D","E","G","J","M","P","Q",
          "D","E","H","K","N","Q","R")
  SSCodeLetters<-matrix(letters,nrow=15, byrow=TRUE)
  rownames(SSCodeLetters)<-LotSize
  colnames(SSCodeLetters)<-InspLev
  #Create Matrix of Double Sample Sizes for Normal Sampling
  temp<-array(c(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,2,2,2,2,2,2,2,2,2,2,
                0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,3,3,3,3,3,3,3,3,3,3,2,
                0,0,0,0,0,0,0,0,0,0,0,0,0,8,5,5,5,5,5,5,5,5,5,5,3,2,
                0,0,0,0,0,0,0,0,0,0,0,0,13,8,8,8,8,8,8,8,8,8,8,5,3,2,
                0,0,0,0,0,0,0,0,0,0,0,20,13,13,13,13,13,13,13,13,8,8,8,5,3,2,
                0,0,0,0,0,0,0,0,0,0,32,20,20,20,20,20,20,20,20,13,8,8,8,5,3,2,
                0,0,0,0,0,0,0,0,0,50,32,32,32,32,32,32,32,32,20,13,8,8,8,5,3,2,
                0,0,0,0,0,0,0,0,80,50,50,50,50,50,50,50,50,32,20,13,8,8,8,5,3,2,
                0,0,0,0,0,0,0,125,80,80,80,80,80,80,80,80,50,32,20,13,8,8,8,5,3,2,
                0,0,0,0,0,0,200,125,125,125,125,125,125,125,125,80,50,32,20,13,8,8,8,5,3,2,
                0,0,0,0,0,315,200,200,200,200,200,200,200,200,125,80,50,32,20,13,8,8,8,5,3,2,
                0,0,0,0,500,315,315,315,315,315,315,315,315,200,125,80,50,32,20,13,8,8,8,5,3,2,
                0,0,0,800,500,500,500,500,500,500,500,500,315,200,125,80,50,32,20,13,8,8,8,5,3,2,
                0,0,1250,800,800,800,800,800,800,800,800,500,315,200,125,80,50,32,20,13,8,8,8,5,3,2,
                0,0,1250,1250,1250,1250,1250,1250,1250,1250,800,500,315,200,125,80,50,32,20,13,8,8,8,5,3,2),
                dim=c(26,16))
  ANSIASQDoubleNormalss <- t(temp)
  rownames(ANSIASQDoubleNormalss)<-codes
  colnames(ANSIASQDoubleNormalss)<-AQL
  #Create Matrix of Double Sample Sizes for Tightened Sampling
  temp<-array(c(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,3,2,0,0,0,0,0,0,0,0,
                0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,3,2,2,2,2,2,2,2,2,2,
                0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,5,3,3,3,3,3,3,3,3,3,2,
                0,0,0,0,0,0,0,0,0,0,0,0,0,13,8,5,5,5,5,5,5,5,5,5,3,2,
                0,0,0,0,0,0,0,0,0,0,0,0,20,13,8,8,8,8,8,8,8,8,8,5,3,2,
                0,0,0,0,0,0,0,0,0,0,0,32,20,13,13,13,13,13,13,13,8,8,8,5,3,2,
                0,0,0,0,0,0,0,0,0,0,50,32,20,20,20,20,20,20,20,13,8,8,8,5,3,2,
                0,0,0,0,0,0,0,0,0,80,50,32,32,32,32,32,32,32,20,13,8,8,8,5,3,2,
                0,0,0,0,0,0,0,0,125,80,50,50,50,50,50,50,50,32,20,13,8,8,8,5,3,2,
                0,0,0,0,0,0,0,200,125,80,80,80,80,80,80,80,50,32,20,13,8,8,8,5,3,2,
                0,0,0,0,0,0,315,200,125,125,125,125,125,125,125,80,50,32,20,13,8,8,8,5,3,2,
                0,0,0,0,0,500,315,200,200,200,200,200,200,200,125,80,50,32,20,13,8,8,8,5,3,2,
                0,0,0,0,800,500,315,315,315,315,315,315,315,200,125,80,50,32,20,13,8,8,8,5,3,2,
                0,0,0,1250,800,500,500,500,500,500,500,500,315,200,125,80,50,32,20,13,8,8,8,5,3,2,
                0,0,2000,1250,800,800,800,800,800,800,800,500,315,200,125,80,50,32,20,13,8,8,8,5,3,2,
                0,0,2000,1250,1250,1250,1250,1250,1250,1250,800,500,315,200,125,80,50,32,20,13,8,8,8,5,3,2),
                dim=c(26,16))
  ANSIASQDoubleTightenedss<-t(temp)
  rownames(ANSIASQDoubleTightenedss)<-codes
  colnames(ANSIASQDoubleTightenedss)<-AQL
  #Create Matrix of Double Sample Sizes for Reduced Sampling
  temp<-array(c(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,
                0,0,0,0,0,0,0,0,0,0,0,0,0,3,2,2,2,2,2,2,2,2,2,2,0,0,
                0,0,0,0,0,0,0,0,0,0,0,0,5,3,3,3,3,3,3,3,3,3,3,2,0,0,
                0,0,0,0,0,0,0,0,0,0,0,8,5,5,5,5,5,5,5,5,3,3,3,2,0,0,
                0,0,0,0,0,0,0,0,0,0,13,8,8,8,8,8,8,8,8,5,3,3,3,2,0,0,
                0,0,0,0,0,0,0,0,0,20,13,13,13,13,13,13,13,13,8,5,3,3,3,2,0,0,
                0,0,0,0,0,0,0,0,32,20,20,20,20,20,20,20,20,13,8,5,3,3,3,2,0,0,
                0,0,0,0,0,0,0,50,32,32,32,32,32,32,32,32,20,13,8,5,3,3,3,2,0,0,
                0,0,0,0,0,0,80,50,50,50,50,50,50,50,50,32,20,13,8,5,3,3,3,2,0,0,
                0,0,0,0,0,125,80,80,80,80,80,80,80,80,50,32,20,13,8,5,3,3,3,2,0,0,
                0,0,0,0,200,125,125,125,125,125,125,125,125,80,50,32,20,13,8,5,3,3,3,2,0,0,
                0,0,0,315,200,200,200,200,200,200,200,200,125,80,50,32,20,13,8,5,3,3,3,2,0,0,
                0,0,500,315,315,315,315,315,315,315,315,200,125,80,50,32,20,13,8,5,3,3,3,2,0,0,
                0,0,500,500,500,500,500,500,500,500,315,200,125,80,50,32,20,13,8,5,3,3,3,2,0,0),
              dim=c(26,16))
  ANSIASQDoubleReducedss<-t(temp)
  rownames(ANSIASQDoubleReducedss)<-codes
  colnames(ANSIASQDoubleReducedss)<-AQL
  #Create array of Acceptance Numbers for Normal Double Sampling
  t<-c( 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 3,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 3, 1, 4,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 3, 1, 4, 2, 6,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 3, 1, 4, 2, 6, 3, 8,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 3, 1, 4, 2, 6, 3, 8, 5,12,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 3, 1, 4, 2, 6, 3, 8, 5,12, 7,18,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 3, 1, 4, 2, 6, 3, 8, 5,12, 7,18,11,26,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 3, 1, 4, 2, 6, 3, 8, 5,12, 7,18,11,26,11,26,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 3, 1, 4, 2, 6, 3, 8, 5,12, 7,18,11,26,11,26,11,26,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 3, 1, 4, 2, 6, 3, 8, 5,12, 7,18,11,26,11,26,11,26,11,26,
        0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 3, 1, 4, 2, 6, 3, 8, 5,12, 7,18,11,26,11,26,11,26,11,26,11,26,
        0, 0, 0, 0, 0, 1, 0, 1, 0, 3, 1, 4, 2, 6, 3, 8, 5,12, 7,18,11,26,11,26,11,26,11,26,11,26,11,26,
        0, 1, 0, 1, 0, 1, 0, 3, 1, 4, 2, 6, 3, 8, 5,12, 7,18,11,26,11,26,11,26,11,26,11,26,11,26,11,26,
        0, 1, 0, 1, 0, 3, 1, 4, 2, 6, 3, 8, 5,12, 7,18,11,26,11,26,11,26,11,26,11,26,11,26,11,26,11,26,
        0, 0, 0, 3, 1, 4, 2, 6, 3, 8, 5,12, 7,18,11,26,11,26,11,26,11,26,11,26,11,26,11,26,11,26,11,26,
        0, 0, 1, 4, 2, 6, 3, 8, 5,12, 7,18,11,26,11,26,11,26,11,26,11,26,11,26,11,26,11,26,11,26,11,26,
        0, 0, 2, 6, 3, 8, 5,12, 7,18,11,26,11,26,11,26,11,26,11,26,11,26,11,26,11,26,11,26,11,26,11,26,
        0, 0, 3, 8, 5,12, 7,18,11,26,11,26,11,26,11,26,11,26,11,26,11,26,11,26,11,26,11,26,11,26,11,26,
        0, 0, 5,12, 7,18,11,26,17,37,17,37,17,37,17,37,17,37,17,37,17,37,17,37,17,37,17,37,17,37,17,37,
        0, 0, 7,18,11,26,17,37,25,56,25,56,25,56,25,56,25,56,25,56,25,56,25,56,25,56,25,56,25,56,25,56,
        0, 0,11,26,17,37,25,56,25,56,25,56,25,56,25,56,25,56,25,56,25,56,25,56,25,56,25,56,25,56,25,56,
        0, 0,17,37,25,56,25,56,25,56,25,56,25,56,25,56,25,56,25,56,25,56,25,56,25,56,25,56,25,56,25,56,
        0, 0,25,56,25,56,25,56,25,56,25,56,25,56,25,56,25,56,25,56,25,56,25,56,25,56,25,56,25,56,25,56)
  AADoubleNormalac<-array(t, dim=c(2,16,26), dimnames=list(c("first","second"),
                                                           c("A","B","C","D","E","F","G","H","J","K","L","M","N","P","Q","R"),
                                                           c("0.010","0.015","0.025","0.040","0.065","0.10","0.15",
                                                             "0.25","0.40","0.65","1.0","1.5","2.5","4.0","6.5",
                                                             "10","15","25","40","65","100","150","250","400","650","1000")))
  # Create array of Rejection Numbers for Normal Double Sampling
  t<-c( 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 3, 4,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 3, 4, 4, 5,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 3, 4, 4, 5, 5, 7,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 3, 4, 4, 5, 5, 7, 7, 9,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 3, 4, 4, 5, 5, 7, 7, 9, 9,13,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 3, 4, 4, 5, 5, 7, 7, 9, 9,13,11,19,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 3, 4, 4, 5, 5, 7, 7, 9, 9,13,11,19,16,27,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 3, 4, 4, 5, 5, 7, 7, 9, 9,13,11,19,16,27,16,27,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 3, 4, 4, 5, 5, 7, 7, 9, 9,13,11,19,16,27,16,27,16,27,
        0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 3, 4, 4, 5, 5, 7, 7, 9, 9,13,11,19,16,27,16,27,16,27,16,27,
        0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 3, 4, 4, 5, 5, 7, 7, 9, 9,13,11,19,16,27,16,27,16,27,16,27,16,27,
        0, 0, 0, 0, 2, 2, 2, 2, 3, 4, 4, 5, 5, 7, 7, 9, 9,13,11,19,16,27,16,27,16,27,16,27,16,27,16,27,
        2, 2, 2, 2, 2, 2, 3, 4, 4, 5, 5, 7, 7, 9, 9,13,11,19,16,27,16,27,16,27,16,27,16,27,16,27,16,27,
        2, 2, 2, 2, 3, 4, 4, 5, 5, 7, 7, 9, 9,13,11,19,16,27,16,27,16,27,16,27,16,27,16,27,16,27,16,27,
        0, 0, 3, 4, 4, 5, 5, 7, 7, 9, 9,13,11,19,16,27,16,27,16,27,16,27,16,27,16,27,16,27,16,27,16,27,
        0, 0, 4, 5, 5, 7, 7, 9, 9,13,11,19,16,27,16,27,16,27,16,27,16,27,16,27,16,27,16,27,16,27,16,27,
        0, 0, 5, 7, 7, 9, 9,13,11,19,16,27,16,27,16,27,16,27,16,27,16,27,16,27,16,27,16,27,16,27,16,27,
        0, 0, 7, 9, 9,13,11,19,16,27,16,27,16,27,16,27,16,27,16,27,16,26,16,26,16,26,16,26,16,27,16,27,
        0, 0, 9,13,11,19,16,27,22,38,22,38,22,38,22,38,22,38,22,38,22,38,22,38,22,38,22,38,22,38,22,38,
        0, 0,11,19,16,27,22,38,31,57,31,57,31,57,31,57,31,57,31,57,31,57,31,57,31,57,31,57,31,57,31,57,
        0, 0,16,27,22,38,31,57,31,57,31,57,31,57,31,57,31,57,31,57,31,57,31,57,31,57,31,57,31,57,31,57,
        0, 0,22,38,31,57,31,57,31,57,31,57,31,57,31,57,31,57,31,57,31,57,31,57,31,57,31,57,31,57,31,57,
        0, 0,31,57,31,57,31,57,31,57,31,57,31,57,31,57,31,57,31,57,31,57,31,57,31,57,31,57,31,57,31,57)
   AADoubleNormalre<-array(t, dim=c(2,16,26), dimnames=list(c("first","second"),
                                                            c("A","B","C","D","E","F","G","H","J","K","L","M","N","P","Q","R"),
                                                            c("0.010","0.015","0.025","0.040","0.065","0.10","0.15",
                                                             "0.25","0.40","0.65","1.0","1.5","2.5","4.0","6.5",
                                                             "10","15","25","40","65","100","150","250","400","650","1000")))
# Create array of acceptance numbers for Double Tightened Sampling
   t<-c( 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
         0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
         0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1,
         0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1,
         0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 3,
         0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 3, 1, 4,
         0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 3, 1, 4, 2, 6,
         0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 3, 1, 4, 2, 6, 3,11,
         0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 3, 1, 4, 2, 6, 3,11, 6,15,
         0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 3, 1, 4, 2, 6, 3,11, 6,15, 9,23,
         0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 3, 1, 4, 2, 6, 3,11, 6,15, 9,23, 9,23,
         0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 3, 1, 4, 2, 6, 3,11, 6,15, 9,23, 9,23, 9,23,
         0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 3, 1, 4, 2, 6, 3,11, 6,15, 9,23, 9,23, 9,23, 9,23,
         0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 3, 1, 4, 2, 6, 3,11, 6,15, 9,23, 9,23, 9,23, 9,23, 9,23,
         0, 0, 0, 0, 0, 1, 0, 1, 0, 1, 0, 3, 1, 4, 2, 6, 3,11, 6,15, 9,23, 9,23, 9,23, 9,23, 9,23, 9,23,
         0, 1, 0, 1, 0, 1, 0, 1, 0, 3, 1, 4, 2, 6, 3,11, 6,15, 9,23, 9,23, 9,23, 9,23, 9,23, 9,23, 9,23,
         0, 1, 0, 1, 0, 1, 0, 3, 1, 4, 2, 6, 3,11, 6,15, 9,23, 9,23, 9,23, 9,23, 9,23, 9,23, 9,23, 9,23,
         0, 1, 0, 1, 0, 3, 1, 4, 2, 6, 3,11, 6,15, 9,23, 9,23, 9,23, 9,23, 9,23, 9,23, 9,23, 9,23, 9,23,
         0, 0, 0, 3, 1, 4, 2, 6, 3,11, 6,15, 9,23, 9,23, 9,23, 9,23, 9,23, 9,23, 9,23, 9,23, 9,23, 9,23,
         0, 0, 1, 4, 2, 6, 3,11, 6,15, 9,23, 9,23, 9,23, 9,23, 9,23, 9,23, 9,23, 9,23, 9,23, 9,23, 9,23,
         0, 0, 2, 6, 3,11, 6,15, 9,23, 9,23, 9,23, 9,23, 9,23, 9,23, 9,23, 9,23, 9,23, 9,23, 9,23, 9,23,
         0, 0, 3,11, 6,15, 9,23,15,34,15,34,15,34,15,34,15,34,15,34,15,34,15,34,15,34,15,34,15,34,15,34,
         0, 0, 6,15, 9,23,15,34,23,52,23,52,23,52,23,52,23,52,23,52,23,52,23,52,23,52,23,52,23,52,23,52,
         0, 0, 9,23,15,34,23,52,23,52,23,52,23,52,23,52,23,52,23,52,23,52,23,52,23,52,23,52,23,52,23,52,
         0, 0,15,34,23,52,23,52,23,52,23,52,23,52,23,52,23,52,23,52,23,52,23,52,23,52,23,52,23,52,23,52,
         0, 0,23,52,23,52,23,52,23,52,23,52,23,52,23,52,23,52,23,52,23,52,23,52,23,52,23,52,23,52,23,52)
   AADoubleTightenedac<-array(t, dim=c(2,16,26), dimnames=list(c("first","second"),
                                                            c("A","B","C","D","E","F","G","H","J","K","L","M","N","P","Q","R"),
                                                            c("0.010","0.015","0.025","0.040","0.065","0.10","0.15",
                                                              "0.25","0.40","0.65","1.0","1.5","2.5","4.0","6.5",
                                                              "10","15","25","40","65","100","150","250","400","650","1000")))
# Create array of rejection numbers for Double Tightened Sampling
   t<-c( 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
         0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
         0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2,
         0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2,
         0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 3, 4,
         0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 3, 4, 4, 5,
         0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 3, 4, 4, 5, 5, 7,
         0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 3, 4, 4, 5, 5, 7, 7,12,
         0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 3, 4, 4, 5, 5, 7, 7,12,10,16,
         0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 3, 4, 4, 5, 5, 7, 7,12,10,16,14,24,
         0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 3, 4, 4, 5, 5, 7, 7,12,10,16,14,24,14,24,
         0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 3, 4, 4, 5, 5, 7, 7,12,10,16,14,24,14,24,14,24,
         0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 3, 4, 4, 5, 5, 7, 7,12,10,16,14,24,14,24,14,24,14,24,
         0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 3, 4, 4, 5, 5, 7, 7,12,10,16,14,24,14,24,14,24,14,24,14,24,
         0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 3, 4, 4, 5, 5, 7, 7,12,10,16,14,24,14,24,14,24,14,24,14,24,14,24,
         2, 2, 2, 2, 2, 2, 2, 2, 3, 4, 4, 5, 5, 7, 7,12,10,16,14,24,14,24,14,24,14,24,14,24,14,24,14,24,
         2, 2, 2, 2, 2, 2, 3, 4, 4, 5, 5, 7, 7,12,10,16,14,24,14,24,14,24,14,24,14,24,14,24,14,24,14,24,
         2, 2, 2, 2, 3, 4, 4, 5, 5, 7, 7,12,10,16,14,24,14,24,14,24,14,24,14,24,14,24,14,24,14,24,14,24,
         0, 0, 3, 4, 4, 5, 5, 7, 7,12,10,16,14,24,14,24,14,24,14,24,14,24,14,24,14,24,14,24,14,24,14,24,
         0, 0, 4, 5, 5, 7, 7,12,10,16,14,24,14,24,14,24,14,24,14,24,14,24,14,24,14,24,14,24,14,24,14,24,
         0, 0, 5, 7, 7,12,10,16,14,24,14,24,14,24,14,24,14,24,14,24,14,24,14,24,14,24,14,24,14,24,14,24,
         0, 0, 7,12,10,16,14,24,20,35,20,35,20,35,20,35,20,35,20,35,20,35,20,35,20,35,20,35,20,35,20,35,
         0, 0,10,16,14,24,20,35,29,53,29,53,29,53,29,53,29,53,29,53,29,53,29,53,29,53,29,53,29,53,29,53,
         0, 0,14,24,20,35,29,53,29,53,29,53,29,53,29,53,29,53,29,53,29,53,29,53,29,53,29,53,29,53,29,53,
         0, 0,20,35,29,53,29,53,29,53,29,53,29,53,29,53,29,53,29,53,29,53,29,53,29,53,29,53,29,53,29,53,
         0, 0,29,53,29,53,29,53,29,53,29,53,29,53,29,53,29,53,29,53,29,53,29,53,29,53,29,53,29,53,29,53)
   AADoubleTightenedre<-array(t, dim=c(2,16,26), dimnames=list(c("first","second"),
                                                               c("A","B","C","D","E","F","G","H","J","K","L","M","N","P","Q","R"),
                                                               c("0.010","0.015","0.025","0.040","0.065","0.10","0.15",
                                                                 "0.25","0.40","0.65","1.0","1.5","2.5","4.0","6.5",
                                                                 "10","15","25","40","65","100","150","250","400","650","1000")))
# Create array of acceptance numbers for Double Reduced Sampling
   t<-c( 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
         0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
         0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
         0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
         0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
         0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 3,
         0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 3, 1, 4,
         0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 3, 1, 4, 2, 6,
         0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 3, 1, 4, 2, 6, 3, 8,
         0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 3, 1, 4, 2, 6, 3, 8, 5,12,
         0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 3, 1, 4, 2, 6, 3, 8, 5,12, 5,12,
         0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 3, 1, 4, 2, 6, 3, 8, 5,12, 5,12, 5,12,
         0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 3, 1, 4, 2, 6, 3, 8, 5,12, 5,12, 5,12, 5,12,
         0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 3, 1, 4, 2, 6, 3, 8, 5,12, 5,12, 5,12, 5,12, 5,12,
         0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 3, 1, 4, 2, 6, 3, 8, 5,12, 5,12, 5,12, 5,12, 5,12, 5,12,
         0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 3, 1, 4, 2, 6, 3, 8, 5,12, 5,12, 5,12, 5,12, 5,12, 5,12, 5,12,
         0, 0, 0, 0, 0, 0, 0, 1, 0, 3, 1, 4, 2, 6, 3, 8, 5,12, 5,12, 5,12, 5,12, 5,12, 5,12, 5,12, 5,12,
         0, 0, 0, 0, 0, 0, 0, 3, 1, 4, 2, 6, 3, 8, 5,12, 5,12, 5,12, 5,12, 5,12, 5,12, 5,12, 5,12, 5,12,
         0, 0, 0, 0, 0, 0, 1, 4, 2, 6, 3, 8, 5,12, 5,12, 5,12, 5,12, 5,12, 5,12, 5,12, 5,12, 5,12, 5,12,
         0, 0, 0, 0, 0, 0, 2, 6, 3, 8, 5,12, 5,12, 5,12, 5,12, 5,12, 5,12, 5,12, 5,12, 5,12, 5,12, 5,12,
         0, 0, 0, 0, 0, 0, 3, 8, 5,12, 5,12, 5,12, 5,12, 5,12, 5,12, 5,12, 5,12, 5,12, 5,12, 5,12, 5,12,
         0, 0, 0, 0, 0, 0, 5,12, 7,18, 7,18, 7,18, 7,18, 7,18, 7,18, 7,18, 7,18, 7,18, 7,18, 7,18, 7,18,
         0, 0, 0, 0, 0, 0, 7,18,11,26,11,26,11,26,11,26,11,26,11,26,11,26,11,26,11,26,11,26,11,26,11,26,
         0, 0, 0, 0, 0, 0,11,26,11,26,11,26,11,26,11,26,11,26,11,26,11,26,11,26,11,26,11,26,11,26,11,26,
         0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
         0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
   AADoubleReducedac<-array(t, dim=c(2,16,26), dimnames=list(c("first","second"),
                                                               c("A","B","C","D","E","F","G","H","J","K","L","M","N","P","Q","R"),
                                                               c("0.010","0.015","0.025","0.040","0.065","0.10","0.15",
                                                                 "0.25","0.40","0.65","1.0","1.5","2.5","4.0","6.5",
                                                                 "10","15","25","40","65","100","150","250","400","650","1000")))

# Create array of rejection numbers for Double Reduced Sampling
   t<-c( 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
         0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
         0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2,
         0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 3, 4,
         0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 3, 4, 4, 5,
         0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 3, 4, 4, 5, 4, 6,
         0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 3, 4, 4, 5, 4, 6, 5, 7,
         0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 3, 4, 4, 5, 4, 6, 5, 7, 7, 9,
         0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 3, 4, 4, 5, 4, 6, 5, 7, 7, 9, 8,12,
         0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 3, 4, 4, 5, 4, 6, 5, 7, 7, 9, 8,12,10,16,
         0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 3, 4, 4, 5, 4, 6, 5, 7, 7, 9, 8,12,10,16,10,16,
         0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 3, 4, 4, 5, 4, 6, 5, 7, 7, 9, 8,12,10,16,10,16,10,16,
         0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 3, 4, 4, 5, 4, 6, 5, 7, 7, 9, 8,12,10,16,10,16,10,16,10,16,
         0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 3, 4, 4, 5, 4, 6, 5, 7, 7, 9, 8,12,10,16,10,16,10,16,10,16,10,16,
         0, 0, 0, 0, 2, 2, 2, 2, 3, 4, 4, 5, 4, 6, 5, 7, 7, 9, 8,12,10,16,10,16,10,16,10,16,10,16,10,16,
         0, 0, 0, 0, 0, 0, 3, 4, 4, 5, 4, 6, 5, 7, 7, 9, 8,12,10,16,10,16,10,16,10,16,10,16,10,16,10,16,
         0, 0, 0, 0, 0, 0, 4, 5, 4, 6, 5, 7, 7, 9, 8,12,10,16,10,16,10,16,10,16,10,16,10,16,10,16,10,16,
         0, 0, 0, 0, 0, 0, 4, 6, 5, 7, 7, 9, 8,12,10,16,10,16,10,16,10,16,10,16,10,16,10,16,10,16,10,16,
         0, 0, 0, 0, 0, 0, 5, 7, 7, 9, 8,12,10,16,10,16,10,16,10,16,10,16,10,16,10,16,10,16,10,16,10,16,
         0, 0, 0, 0, 0, 0, 7, 9, 8,12,10,16,10,16,10,16,10,16,10,16,10,16,10,16,10,16,10,16,10,16,10,16,
         0, 0, 0, 0, 0, 0, 8,12,10,16,10,16,10,16,10,16,10,16,10,16,10,16,10,16,10,16,10,16,10,16,10,16,
         0, 0, 0, 0, 0, 0,10,16,12,22,12,22,12,22,12,22,12,22,12,22,12,22,12,22,12,22,12,22,12,22,12,22,
         0, 0, 0, 0, 0, 0,12,22,17,30,17,30,17,30,17,30,17,30,17,30,17,30,17,30,17,30,17,30,17,30,17,30,
         0, 0, 0, 0, 0, 0,17,30,17,30,17,30,17,30,17,30,17,30,17,30,17,30,17,30,17,30,17,30,17,30,17,30,
         0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
         0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
   AADoubleReducedre<-array(t, dim=c(2,16,26), dimnames=list(c("first","second"),
                                                              c("A","B","C","D","E","F","G","H","J","K","L","M","N","P","Q","R"),
                                                              c("0.010","0.015","0.025","0.040","0.065","0.10","0.15",
                                                                "0.25","0.40","0.65","1.0","1.5","2.5","4.0","6.5",
                                                                "10","15","25","40","65","100","150","250","400","650","1000")))
# Get Code letter from SSCodeLetters
   codelet<-SSCodeLetters[dLOTS,dINSL]
   if(PLAN == 1) {
     ac<-AADoubleNormalac[ ,codelet,dAQL]
     re<-AADoubleNormalre[ ,codelet,dAQL]
     S<-ANSIASQDoubleNormalss[codelet, dAQL]
     ss<-c(S,S)
     names(ss)<-c("first","second")
   } else if(PLAN == 2) {
     ac<-AADoubleTightenedac[ ,codelet,dAQL]
     re<-AADoubleTightenedre[ ,codelet,dAQL]
     S<-ANSIASQDoubleTightenedss[codelet, dAQL]
     ss<-c(S,S)
     names(ss)<-c("first","second")
   } else if(PLAN == 3) {
     ac<-AADoubleReducedac[ ,codelet,dAQL]
     re<-AADoubleReducedre[ ,codelet,dAQL]
     S<-ANSIASQDoubleReducedss[codelet, dAQL]
     ss<-c(S,S)
   }
     if(ss[1]==0){
       warning("No multiple sampling exists. Use the corresponding single sampling plan")
      }
     else {plan<-data.frame(n=ss,c=ac,r=re)
      return(plan)}
}
