% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apf_fdr.R
\name{apf_fdr}
\alias{apf_fdr}
\title{Implementation of APF and FDR robust estimation}
\usage{
apf_fdr(data, type = "datf", corr = "spearman", lobs = 0,
  seed = 111, gamm = c(1e-04, 0.1, 0.002))
}
\arguments{
\item{data}{Either a vector, matrix or dataframe.}

\item{type}{Set \code{"datf"} if \code{data} is a matrix or dataframe containing
the raw data (columns); \code{"pvl"} for a vector of p-values.}

\item{corr}{The type of correlation to use when \code{type = "datf"}. It can be
set to either \code{"spearman"} or \code{"pearson"}.}

\item{lobs}{When \code{type = "pvl"}, it indicates the number of datapoints used to
compute the correlations.}

\item{seed}{A seed (natural number) for the resampling.}

\item{gamm}{The threshold gamma on the p-values to explore (typically \eqn{\le} 0.05 or
0.1). A min, max and step length value need to be set.}
}
\value{
A list with four elements. A vector \code{APF_gamma} containing the robust
estimates of APF (5th quantiles) for all the gamma values set in \code{gamm}. A vector
\code{FDR_gamma} with the robust estimates of Bayes FDR (95th quantiles). A
vector \code{tau_gamma} with the correlation coefficients \emph{tau} for each gamma
value explored and another vector with the relative values gamma (\code{gammaval}).
}
\description{
\code{apf_fdr} returns robust estimates of the Average Power Function (APF)
and Bayes False Discovery Rate (FDR) for each value of the threshold Gamma
on the p-value and Tau on the correlation coefficient.
}
\examples{
\donttest{data("Ex1")
APF_lst <- apf_fdr(Ex1,"pvl",lobs=100)}
# The example uses the dataset Ex1 (in the APFr package) which is
# a vector of 100 p-values. The number of datapoints used to
# compute each p-value in this example is set to 100. As a result,
# a list of 4 objects is returned.
\dontshow{
prova <- runif(3)
apf_fdr(prova,"pvl",lobs=15,gamm=c(0.01,0.05,0.02))}

}
\references{
Quatto, P, Margaritella, N, et al. Brain networks
construction using Bayes FDR and average power function. \emph{Stat Methods Med Res}.
Published online May 14th, 2019; DOI:10.1177/0962280219844288.
}
