% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_ins_support.R
\name{calc_ins_support}
\alias{calc_ins_support}
\title{Calculate Instrumental Support Score}
\usage{
calc_ins_support(survey_df)
}
\arguments{
\item{survey_df}{A data frame containing survey data with at least three columns:
`person_id`, `question_concept_id`, and `answer_concept_id`.}
}
\value{
A data frame with two columns: `person_id` and `ins_support`, where `ins_support`
is the calculated instrumental support score for each participant. The score is scaled from 0 to 100, with higher values indicating more tangible support.
Participants who did not answer all four relevant questions will have NA values.
}
\description{
This function computes a numeric instrumental support score ranging from 0 to 100.
The score is the mean of individual item scores transformed to a 0-100 scale, where higher scores indicate greater tangible support.
}
\examples{
# Create a sample survey data frame
survey_df <- data.frame(
  person_id = rep(1:3, each = 4),
  question_concept_id = rep(c(40192388, 40192442, 40192480, 40192511), times = 3),
  answer_concept_id = sample(c(40192454, 40192518, 40192486, 40192382, 40192521),
                             12, replace = TRUE)
)

# Compute instrumental support scores
ins_support_scores <- calc_ins_support(survey_df)
head(ins_support_scores)

}
