% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_edd_frequency.R
\name{calc_edd_frequency}
\alias{calc_edd_frequency}
\title{Calculate Everyday Discrimination Frequency Score}
\usage{
calc_edd_frequency(survey_df, reason)
}
\arguments{
\item{survey_df}{A data frame containing survey data with at least three columns:
`person_id`, `question_concept_id`, and `answer_concept_id`.}

\item{reason}{An optional argument specifying the reason for perceived discrimination, e.g., race or age.
If provided, the function will limit the analysis to participants who reported this reason.}
}
\value{
A data frame with two columns: `person_id` and `edd_frequency`, where `edd_frequency`
is the calculated frequency score for each participant. Participants who did not answer all 9 questions
or did not specify the given reason (if provided) will have an NA score.
}
\description{
This function computes a frequency score indicating how often participants experience perceived discrimination
based on 9 specific survey items. The score ranges from 9 to 54, where higher scores indicate more frequent
perceived unfair treatment. The function also allows for filtering by a specific reason for discrimination.
}
\examples{
# Create a sample survey data frame
survey_df <- data.frame(
  person_id = rep(1:3, each = 9),
  question_concept_id = rep(c(40192380, 40192395, 40192416, 40192451, 40192466,
                              40192489, 40192490, 40192496, 40192519), times = 3),
  answer_concept_id = sample(c(40192465, 40192464, 40192453, 40192461, 40192391,
                               40192421), 27, replace = TRUE)
)

# Compute everyday discrimination frequency scores
edd_frequency_scores <- calc_edd_frequency(survey_df)
head(edd_frequency_scores)

}
