% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zelen.R
\name{zelen}
\alias{zelen}
\title{Perform Zelen test}
\usage{
zelen(x, y, z, max.exact.perms = 1e+06, do.exact = TRUE)
}
\arguments{
\item{x}{Binary factor of same length as y, z}

\item{y}{Binary factor of same length as x, z}

\item{z}{Factor of same length as x, y}

\item{max.exact.perms}{Maximum number of permutations allowed for exact calculations (defaults to \code{1000000})}

\item{do.exact}{Boolean indicating whether or not to perform exact calculations (defaults to \code{TRUE})}
}
\value{
An ANSMtest object with the results from applying the function
}
\description{
\code{zelen()} performs the Zelen test and is used in chapter 13 of "Applied Nonparametric Statistical Methods" (5th edition)
}
\examples{
# Section 13.2.5 from "Applied Nonparametric Statistical Methods" (5th edition)
zelen(ch13$drug, ch13$side.effects, ch13$age.group)

# Example 13.3 from "Applied Nonparametric Statistical Methods" (5th edition)
zelen(ch13$machine, ch13$output.status, ch13$material.source)

}
