% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AMIS_outputs.R
\name{plot.amis}
\alias{plot.amis}
\title{Plot histogram or credible interval of weighted distributions given a model fitted by \code{\link{amis}()}}
\usage{
\method{plot}{amis}(
  x,
  what = "prev",
  type = "hist",
  locations = 1,
  time = 1,
  measure_central = "mean",
  order_locations_by = NULL,
  display_location_names = FALSE,
  alpha = 0.05,
  breaks = 500,
  cex = 1,
  lwd = 1,
  xlim = NULL,
  main = NULL,
  xlab = NULL,
  ylab = NULL,
  ...
)
}
\arguments{
\item{x}{The output from the function \code{\link{amis}()}.}

\item{what}{What posterior distribution should be plotted.
It can be \code{"prev"} (default) for plotting prevalences, or one of the parameter names.}

\item{type}{Type of plot. It can be \code{"hist"} (default) for histogram,
or \code{"CI"} for credible intervals}

\item{locations}{Integer vector or location names identifying locations the plots are made for. Default to \code{1} (first location).}

\item{time}{Integer index identifying the timepoint. Default to \code{1}.}

\item{measure_central}{Measure of central tendency for credible interval plots.
It can be \code{"mean"} (default) or \code{"median"}.}

\item{order_locations_by}{How the credible intervals of multiple locations should be ordered.
If \code{NULL} (default), locations are displayed according to the argument \code{"locations"}.
Otherwise, it must be either \code{"prev"} or one of the parameter names, and then the
locations are ranked by the corresponding measure of central tendency.}

\item{display_location_names}{Logical indicating whether location names are to be shown or not
in credible interval plots. Default to \code{FALSE}.}

\item{alpha}{Numeric value between 0 and 1 indicating the endpoints of the
credible intervals, which are evaluated at (alpha/2, 1-alpha/2)\% quantiles.
Default (\code{0.05}) will create 95\% credible intervals.}

\item{breaks}{Argument passed to \code{\link[weights]{wtd.hist}()} for histogram plots.
Default to \code{500}.}

\item{cex}{Argument passed to plots of credible intervals.
Default to \code{1}.}

\item{lwd}{Argument passed to plots of credible intervals.
Default to \code{1}.}

\item{xlim}{The x limits of the plots. For for credible intervals of multiple
statistics (i.e. \code{length(what)>1)}, it must be either \code{NULL} or a list with
the x limits for each statistic. Default to \code{NULL}.}

\item{main}{Title for the plot.}

\item{xlab}{Lable for the x axis.}

\item{ylab}{Lable for the y axis.}

\item{...}{Other graphical parameters passed to \code{\link[weights]{wtd.hist}()}.}
}
\value{
A plot.
}
\description{
Plot histogram or credible interval of weighted distributions given a model fitted by \code{\link{amis}()}
}
\details{
For illustrative examples, see \code{\link{amis}()}.
}
