% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_true_beta}
\alias{get_true_beta}
\title{get_true_beta}
\usage{
get_true_beta(n_var, c, pi, sigma, null = TRUE)
}
\arguments{
\item{n_var}{total number of variants}

\item{c}{slope between the two sets of variant effect sizes, only applicable when `null` == TRUE}

\item{pi}{probability of variant of having no effect on the phenotype}

\item{sigma}{variance of the two sets of effect sizes}

\item{null}{whether to simulate data under the null hypothesis (no linear relationship) or the alternative hypothesis}
}
\value{
A 2x`n_var` matrix of effect size information for `n_var` variants (first row corresponds to the first phenotype, second row corresponds to the second phenotype)
}
\description{
simulation function: simulate true effect size information of `n_var` variants for two phenotypes
}
\examples{
true_beta <- get_true_beta(n_var=100, c=0.6, pi=0.5, sigma=1, null=TRUE)
}
