% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ACWR.R
\name{plot_ACWR}
\alias{plot_ACWR}
\title{ACWR plots using d3.js}
\usage{
plot_ACWR(
  db,
  TL,
  ACWR,
  day,
  ID = NULL,
  colour = NULL,
  xLabel = NULL,
  y0Label = NULL,
  y1Label = NULL,
  plotTitle = NULL
)
}
\arguments{
\item{db}{a data frame}

\item{TL}{training load}

\item{ACWR}{Acute Chronic Workload Ratio}

\item{day}{training days}

\item{ID}{ID of the subjects}

\item{colour}{colour of the bars. By default "#87CEEB" (skyblue)}

\item{xLabel}{x-axis label. By default "Days"}

\item{y0Label}{left y-axis label. By default "Load [AU]"}

\item{y1Label}{right y-axis label. By default "Acute:chronic worload ratio"}

\item{plotTitle}{Title of the plot. By default "ACWR"}
}
\value{
This function returns a d3.js object for a single subject.
         For several subjects it returns a list of d3.js objects.
}
\description{
ACWR plots using d3.js
}
\examples{

\dontrun{
# Get old working directory
oldwd <- getwd()

# Set temporary directory
setwd(tempdir())

# Read db
data("training_load", package = "ACWR")

# Convert to data.frame
training_load_db <- data.frame(training_load)

# Calculate ACWR
result_ACWR <- ACWR(db = training_load_db,
                 ID = "ID",
                 TL = "TL",
                 weeks = "Week",
                 days = "Day",
                 training_dates = "Training_Date",
                 ACWR_method = c("EWMA", "RAC", "RAU"))

# Plot for 1 subject
# Select the first subject
result_ACWR_1 <- result_ACWR[result_ACWR[["ID"]] == 1,  ]

# plot ACWR (e.g. EWMA)
ACWR_plot_1 <- plot_ACWR(db = result_ACWR_1,
                         TL = "TL",
                         ACWR = "EWMA_ACWR",
                         day = "Day")

# Plot for several subjects
# plot ACWR (e.g. RAC)
ACWR_plot <- plot_ACWR(db = result_ACWR,
                         TL = "TL",
                         ACWR = "RAC_ACWR",
                         day = "Day",
                         ID = "ID")

# set user working directory
setwd(oldwd)
}

}
