% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ACWR.R
\name{ACWR}
\alias{ACWR}
\title{Acute Chronic Workload Ratio}
\usage{
ACWR(
  db,
  ID,
  TL,
  weeks,
  days,
  training_dates,
  ACWR_method = c("EWMA", "RAC", "RAU")
)
}
\arguments{
\item{db}{a data frame}

\item{ID}{ID of the subjects}

\item{TL}{training load}

\item{weeks}{training weeks}

\item{days}{training days}

\item{training_dates}{training dates}

\item{ACWR_method}{method to calculate ACWR}
}
\value{
a data frame with the acute & chronic training load and ACWR calculated
        with the selected method/s and added on the left side of the data frame
}
\description{
Acute Chronic Workload Ratio
}
\examples{

\dontrun{
# Get old working directory
oldwd <- getwd()

# Set temporary directory
setwd(tempdir())

# Read dfs
data("training_load", package = "ACWR")

# Convert to data.frame
training_load <- data.frame(training_load)

# Calculate ACWR
result_ACWR <- ACWR(db = training_load,
                 ID = "ID",
                 TL = "TL",
                 weeks = "Week",
                 days = "Day",
                 training_dates = "Training_Date",
                 ACWR_method = c("EWMA", "RAC", "RAU"))

# set user working directory
setwd(oldwd)
}

}
