% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Power_LS.R
\name{Power_LS}
\alias{Power_LS}
\title{Power_LS}
\usage{
Power_LS(N1, N2, power, p_N1 = NULL, h2, c2, R1 = 1, R2 = 0.5, alpha = 0.05)
}
\arguments{
\item{N1}{The number of kin pairs for group1 (amount of PAIRS)}

\item{N2}{The number of kin pairs for group2}

\item{power}{The power of heritability estimation. Specified if you want to return the required sample sizes.}

\item{p_N1}{The proportion of kin group1 over the . Required to be specified if the user wants to calculate the N1 and N2 simultaneously.}

\item{h2}{The assumed standard heritability value of the target trait. 0 < h2 < 1}

\item{c2}{The assumed standard common environmental effects on the target trait. 0 < c2 < 2}

\item{R1}{The genetic relatedness of kin pair group1}

\item{R2}{The genetic relatedness of kin pair group2}

\item{alpha}{The type-one error rate for heritability estimation.}
}
\value{
A numeric \code{vector} of power when \code{N1} and \code{N2} are both specified.
\cr
A numeric \code{vector} of \code{N1} (or \code{N2}) when \code{N2} (or \code{N1}) is specified. A numeric \code{vector} of \code{N1} and \code{N2} when \code{RatioN} is specified.
}
\description{
The function is designed for calculating the power of heritability estimation from ACE models given the parameter settings. Or calculate one of the parameter settings (N,R,h2,c2) given the rest of known parameters.
This power calculator is made based on the Least Squares theory and follows the mathematical derivation proposed by Visscher(2004).
}
