% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{ABRSQOL}
\alias{ABRSQOL}
\title{ABRSQOL numerical solution algorithm to invert a quality of life measure}
\usage{
ABRSQOL(
  df,
  w = "w",
  p_H = "p_H",
  P_t = "P_t",
  p_n = "p_n",
  L = "L",
  L_b = "L_b",
  alpha = 0.7,
  beta = 0.5,
  gamma = 3,
  xi = 5.5,
  conv = 0.5,
  tolerance = 1e-10,
  maxiter = 10000
)
}
\arguments{
\item{df}{input data containing variables refenced by 
following arguments: data.frame or matrix}

\item{w}{wage index variable name or column index:
character or integer (or list), default='w'}

\item{p_H}{floor_space_price variable name or column index:
character or integer, default='p_H'}

\item{P_t}{tradable_goods_price variable name or column index:
character or integer, default='P_t'}

\item{p_n}{local_services_price variable name or column index:
character or integer, default='p_n'}

\item{L}{residence_population variable name or column index:
character or integer, default='L'}

\item{L_b}{hometown_population variable name or column index:
character or integer, default='L_b'}

\item{alpha}{Income share on non-housing consumtpion:
double, default=0.7}

\item{beta}{Share of tradable goods in non-housing consumption:
double, default=0.5}

\item{gamma}{Idiosyncratic taste dispersion (inverse labour
supply elasticity):
double, default=3}

\item{xi}{Valuation of local ties: double, default=5}

\item{conv}{Convergence parameter (Hgher value increases spead of,
convergence and risk of bouncing): double, default=0.5}

\item{tolerance}{Value used in stopping rule (The mean absolute error (MAE).
Smaller values imply greater precision and longer convergence):
double, default=1e-10}

\item{maxiter}{Maximum number of iterations after which the algorithm
is forced to stop: integer, default=1e4}
}
\value{
inverted quality of life measure as Numeric vector
(identified up to a constant)
}
\description{
This toolkit implements a numerical solution algorithm
to invert a quality of life (QoL) from observed data
in various programming languages. The QoL measure is
based on Ahlfeldt, Bald, Roth, Seidel (2024):
Measuring quality of life under spatial frictions.
Unlike the traditional Rosen-Roback measure, this measure
accounts for mobility frictions—generated by idiosyncratic
tastes and local ties—and trade frictions—generated by
trade costs and non-tradable services, thereby reducing
non-classical measurement error.
When using this programme or the toolkit in your work, please cite the paper.
}
\details{
Notice that quality of life is identified up to a constant.
Therefore, the inverted QoL measures measure has a relative
interpretation only. We normalize the QoL relative to the first
observation in the data set. It is straightforward to rescale
the QoL measure to any other location or any other value (such
as the mean or median in the distribution of QoL across locations).
}
\examples{
# Example 1: 
# load testdata, 
# run QoL inversion with default parameters and append result
data(ABRSQOL_testdata)
my_dataframe <- ABRSQOL_testdata
my_dataframe$qol1 <- ABRSQOL(df=ABRSQOL_testdata)
my_dataframe

# Example 2: load your data from csv, run inversion, save result as csv
# my_dataframe <- read.csv("path/to/your/csv_filename.csv")
# my_dataframe$qol2 <- ABRSQOL(
#  # supply your dataset as a dataframe
#  df=my_dataframe,
#  # and specify the corresponding variable name for your dataset
#  w = 'wage',
#  p_H = 'floor_space_price',
#  P_t = 'tradable_goods_price',
#  p_n = 'local_services_price',
#  L = 'residence_pop',
#  L_b = 'L_b',
#  # freely adjust remaining parameters
#  alpha = 0.7,
#  beta = 0.5,
#  gamma = 3,
#  xi = 5.5,
#  conv = 0.3,
#  tolerance = 1e-11,
#  maxiter = 50000
#)
#write.csv(my_dataframe, 'qol_of_my_data.csv'

# Example 3: Reference variables in your dataset by using the column index
my_dataframe$qol3 <- ABRSQOL(
  df=my_dataframe,
  w = 1,
  p_H = 3,
  P_t = 4,
  p_n = 2,
  L = 6,
  L_b = 5
)

# Example 4: Having named the variables in your data according to the 
# default parameters, you can ommit specifying variable names
my_dataframe$qol4 <- ABRSQOL(
  df=my_dataframe,
  alpha = 0.7,
  beta = 0.5,
  gamma = 3,
  xi = 5.5,
  conv = 0.5
)

}
