\name{Predict.matrix.cr.smooth}
\alias{Predict.matrix.cr.smooth}
\alias{Predict.matrix.cs.smooth}
\alias{Predict.matrix.cyclic.smooth}
\alias{Predict.matrix.pspline.smooth}
\alias{Predict.matrix.tensor.smooth}
\alias{Predict.matrix.tprs.smooth}
\alias{Predict.matrix.ts.smooth}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Predict matrix method functions}
\description{The various built in smooth classes for use with \code{\link{gam}} have associate \code{\link{Predict.matrix}} 
method functions to enable prediction from the fitted model. }


\usage{
\method{Predict.matrix}{cr.smooth}(object, data)
\method{Predict.matrix}{cs.smooth}(object, data)
\method{Predict.matrix}{cyclic.smooth}(object, data)
\method{Predict.matrix}{pspline.smooth}(object, data)
\method{Predict.matrix}{tensor.smooth}(object, data)
\method{Predict.matrix}{tprs.smooth}(object, data)
\method{Predict.matrix}{ts.smooth}(object, data)
}

\arguments{ 
\item{object}{a smooth object, usually generated by a \code{\link{smooth.construct}} method having 
processed a smooth specification object generated by an \code{\link{s}} or \code{\link{te}} term in a 
\code{\link{gam}} formula.}

\item{data}{ A data frame containing the values of the (named) covariates at which the smooth term is to be 
evaluated. Exact requirements are as for \code{\link{smooth.construct}} and \code{smooth.construct2}}.

}


\value{ A matrix mapping the coeffients for the smooth term to its values at the supplied data values. 
}

\details{ 
The Predict matrix function is not normally called directly, but is rather used internally by \code{\link{predict.gam}} etc. 
to predict from a fitted \code{\link{gam}} model. See \code{\link{Predict.matrix}} for more details, or the specific 
\code{smooth.construct} pages for details on a particular smooth class.
}

\references{
Wood S.N. (2006) Generalized Additive Models: An Introduction with R. Chapman
and Hall/CRC Press.
}

\author{ Simon N. Wood \email{simon.wood@r-project.org}}

\examples{
## see smooth.construct
 

}
\keyword{models} \keyword{regression}%-- one or more ..


