\name{print.trellis}
\title{Print Trellis Objects}
\usage{
\method{print}{trellis}(x, position, split,
     more = FALSE, newpage = TRUE,
     panel.height = list(1, "null"),
     panel.width = list(1, "null"),
     ...)
}
\description{
  Print (plot) a trellis object.
}
\alias{print.trellis}
\arguments{
  \item{x}{ The object to be plotted, of class ``trellis''}
  \item{position}{ a vector of 4 numbers, typically c(xmin, ymin, xmax,
    ymax) that give the lower-left and upper-right corners of a
    rectangle in which the Trellis plot of x is to be positioned. The
    coordinate system for this rectangle is [0-1] in both the x and y
    directions.
  }
  \item{split}{ a vector of 4 integers, c(x,y,nx,ny) , that says to
    position the current plot at the x,y position in a regular array of
    nx by ny plots. (Note: this has origin at top left)
  }
  \item{more}{ A logical specifying whether more plots will follow on
    this page.
  }
  \item{newpage}{ A logical specifying whether the plot should be on a
    new page. This option is specific to lattice, and is useful for
    including lattice plots in an arbitrary grid viewport (see the
    details section).
  }
  \item{panel.width, panel.height}{ lists with 2 components, that should
    be valid \code{x} and \code{units} arguments to \code{unit()} (the
    \code{data} argument cannot be specified currently, but can be
    considered for addition if needed). The resulting \code{unit} object
    will be the width/height of each panel in the Lattice plot. These
    arguments can be used to explicitly control the dimensions of the
    panel, rather than letting them expand to maximize available space.

    Note that this option should not be used in conjunction with
    non-default values of the \code{aspect} argument in the original
    high level call (no error will be produced, but the resulting
    behaviour is undefined).
  }
  \item{\dots}{extra arguments, ignored}
}
\details{
  This is the default print method for objects of class
  \code{"trellis"}, produced by calls to functions like \code{xyplot,
    bwplot} etc. It is usually called automatically when a trellis
  object is produced. It can also be called explicitly to control plot
  positioning by means of the arguments \code{split} and
  \code{position}.

  When \code{newpage = FALSE}, the current grid viewport is treated as
  the plotting area, making it possible to embed a Lattice plot inside
  an arbitrary grid viewport.

  The print method uses the information in \code{x} (the object to be
  printed) to produce a display using the Grid graphics engine. At the
  heart of the plot is a grid layout, of which the entries of most
  interest to the user are the ones containing the display panels.

  Unlike in older versions of Lattice (and Grid), the grid display tree
  is retained after the plot is produced, making it possible to access
  individual viewport locations and make additions to the plot. The full
  tree can be viewed using the grid function
  \code{\link[grid:current.viewport]{current.vpTree}}, and individual
  viewports can be `seeked' using
  \code{\link[grid:viewports]{seekViewport}}.  The viewports that
  correspond to panels (which is what the user would be interested in)
  have names of the form \code{panel.n}, where \code{n} is a simple
  incremental counter for the panels. These names can be used in
  \code{seekViewport}. For multi-page displays, only the viewports for
  the last page are available.  This functionality is still very new,
  and details may change in the future.

}

\note{
  Trying to position multipage displays will mess things up.
}

\seealso{
  \code{\link{Lattice}}, \code{\link[grid:unit]{unit}}
}
\author{ Deepayan Sarkar \email{deepayan@stat.wisc.edu}}
\examples{
data(singer)
p11 <- histogram( ~ height | voice.part, data = singer, xlab="Height")
p12 <- densityplot( ~ height | voice.part, data = singer, xlab = "Height")
p2 <- histogram( ~ height, data = singer, xlab = "Height")
data(sunspot)
p3 <- xyplot(sunspot~1:37, aspect="xy", type = "l")
## simple positioning by split
print(p11, split=c(1,1,1,2), more=TRUE)
print(p2, split=c(1,2,1,2))

## Combining split and position:
print(p11, position = c(0,0,.75,.75), split=c(1,1,1,2), more=TRUE)
print(p12, position = c(0,0,.75,.75), split=c(1,2,1,2), more=TRUE)
print(p3, position = c(.5,.75,1,1), more=FALSE)

## Using seekViewport
data(longley)

## repeat same plot, with different polynomial fits in each panel
xyplot(Armed.Forces ~ Year, longley, index.cond = list(rep(1, 6)),
       panel = function(x, y, panel.counter, ...)
       {
           panel.xyplot(x, y, ...)
           fm <- lm(y ~ poly(x, panel.counter))
           llines(x, predict(fm))
       })

\dontrun{
grid::seekViewport("panel.1")
cat("Click somewhere inside the first panel:\n")
ltext(grid::grid.locator(), lab = "linear")
}

grid::seekViewport("panel.1")
grid::grid.text("linear")

grid::seekViewport("panel.2")
grid::grid.text("quadratic")

grid::seekViewport("panel.3")
grid::grid.text("cubic")

grid::seekViewport("panel.4")
grid::grid.text("degree 4")

grid::seekViewport("panel.5")
grid::grid.text("degree 5")

grid::seekViewport("panel.6")
grid::grid.text("degree 6")
}
\keyword{hplot}



