% $Id: Covariate.varFunc.Rd,v 1.1 2000/07/03 18:22:45 bates Exp $
\name{Covariate.varFunc}
\title{Assign varFunc Covariate}
\usage{
covariate(object) <- value
}
\alias{covariate<-.varFunc}
\arguments{
 \item{object}{an object inheriting from class \code{varFunc},
   representing a variance function structure.} 
 \item{value}{a value to be assigned to the covariate associated with
   \code{object}.}
}
\description{
  The covariate(s) used in the calculation of the weights of the
  variance function represented by \code{object} is (are) replaced by
  \code{value}. If \code{object} has been initialized, \code{value} must
  have the same dimensions as \code{getCovariate(object)}.
}
\value{
  a \code{varFunc} object similar to \code{object}, but with its
  \code{covariate} attribute replaced by \code{value}.
}

\author{Jose Pinheiro \email{Jose.Pinheiro@pharma.novartis.com} and Douglas Bates \email{bates@stat.wisc.edu}}

\seealso{\code{\link{getCovariate.varFunc}}}

\examples{
data(Orthodont)
vf1 <- varPower(1.1, form = ~age)
covariate(vf1) <- Orthodont[["age"]]
}
\keyword{models}
