% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute.R
\name{impute_df}
\alias{impute_df}
\title{Imputation}
\usage{
impute_df(x, limits, method = c("logmean", "mean", "min", "max"))
}
\arguments{
\item{x}{\code{data.frame}, with the columns: "age", \code{numeric}, "sex", \code{factor}
and more user defined \code{numeric} columns that should be imputed.}

\item{limits}{\code{data.frame}, reference table, has to have the columns:
"age", \code{numeric} (same units as in \code{age}, e.g. days or years, age of \code{0}
matches all ages),
"sex", \code{factor} (same levels for male and female as \code{sex} and a special level
\code{"both"}), "param", \code{character} with the laboratory parameter name that have
to match the column name in \code{x}, "lower" and "upper", \code{numeric} for the
lower and upper reference limits.}

\item{method}{\code{character}, imputation method. \code{method = "logmean"} (default)
replaces all \code{NA} with its corresponding logged mean values for the reference
table \code{limits} (for subsequent use of the \emph{zlog} score,
use \verb{method = "mean" for *z* score calculation). For }method = "min"\code{or}method = "max"` the lower or the upper limits are
used.}
}
\value{
\code{data.frame}, the same as \code{x} but missing values are replaced by
the corresponding logmean, mean, minimal or maximal reference values
depending on the chosen \code{method}.
}
\description{
Impute \code{NA} values with the logmean, mean, minimal or maximum reference value.
}
\note{
Imputation should be done prior to \code{\link[=z]{z()}}/\code{\link[=zlog]{zlog()}} transformation.
Afterwards the \code{NA} could replaced by zero (for mean-imputation) via
\code{d[is.na(d)] <- 0}.
}
\examples{
l <- data.frame(
    param = c("alb", "bili"),
    age = c(0, 0),
    sex = c("both", "both"),
    units = c("mg/l", "µmol/l"),
    lower = c(35, 2),
    upper = c(52, 21)
)
x <- data.frame(
    age = 40:48,
    sex = rep(c("female", "male"), c(5, 4)),
    # from Hoffmann et al. 2017
    alb = c(42, NA, 38, NA, 50, 42, 27, 31, 24),
    bili = c(11, 9, NA, NA, 22, 42, NA, 200, 20)
)
impute_df(x, l)
impute_df(x, l, method = "min")
zlog_df(impute_df(x, l), l)
}
\author{
Sebastian Gibb
}
