#' zebu: Local Association Measures
#'
#' The zebu package implements the estimation of local (and global) association measures:
#' Ducher's Z, Lewontin's D, pointwise mutual information, normalized pointwise mutual information and chi-squared residuals.
#' The significance of local (and global) association is accessed using p-values estimated by permutations.
#'
#' @section Functions:
#'
#' \code{\link[zebu]{lassie}} estimates local (and global) association measures: Ducher's Z, Lewontin's D, pointwise mutual information, normalized pointwise mutual information and chi-squared residuals.
#'
#' \code{\link[zebu]{permtest}} accesses the significance of local (and global) association values usingp-values estimated by permutations.
#'
#' \code{\link[zebu]{permtest}} accesses the significance for two dimensional chi-squared analysis.
#'
#' @docType package
#' @name zebu
#'
NULL
