% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/json-opts.R
\name{opts_write_json}
\alias{opts_write_json}
\title{Create named list of options for serializing R to JSON}
\usage{
opts_write_json(
  digits = -1,
  pretty = FALSE,
  auto_unbox = FALSE,
  dataframe = c("rows", "columns"),
  factor = c("string", "integer"),
  name_repair = c("none", "minimal"),
  num_specials = c("null", "string"),
  str_specials = c("null", "string"),
  yyjson_write_flag = 0L
)
}
\arguments{
\item{digits}{decimal places to keep for floating point numbers. Default: -1.
Positive values specify number of decimal places. Using zero will
write the numeric value as an integer. Values less than zero mean that
the floating point value should be written as-is (the default).}

\item{pretty}{Logical value indicating if the created JSON string should have
whitespace for indentation and linebreaks. Default: FALSE.
Note: this option is equivalent to \code{yyjson_write_flag = write_flag$YYJSON_WRITE_PRETTY}}

\item{auto_unbox}{automatically unbox all atomic vectors of length 1 such that
they appear as atomic elements in JSON rather than arrays of length 1.}

\item{dataframe}{how to encode data.frame objects. Options 'rows' or
columns'.  Default: 'rows'}

\item{factor}{how to encode factor objects: must be one of 'string' or 'integer'
Default: 'string'}

\item{name_repair}{How should unnamed items in a partially named list be handled?
'none' means to leave their names blank in JSON (which may not be valid JSON).
'minimal' means to use the integer position index of the item as its name if
it is missing.  Default: 'none'}

\item{num_specials}{Should special numeric values (i.e. NA, NaN, Inf) be
converted to a JSON \code{null} value or converted to a string
representation e.g. "NA"/"NaN" etc.   Default: 'null'}

\item{str_specials}{Should a special value of \code{NA} in a character vector
be converted to a
JSON \code{null} value, or converted to a string "NA"?  Default: 'null'}

\item{yyjson_write_flag}{integer vector corresponding to internal \code{yyjson}
options.  See \code{yyjson_write_flag} in this package, and read
the yyjson API documentation for more information.  This is considered
an advanced option.}
}
\value{
Named list of options for writing JSON
}
\description{
Create named list of options for serializing R to JSON
}
\examples{
write_json_str(head(iris, 3), opts = opts_write_json(factor = 'integer'))
}
\seealso{
\code{\link[=yyjson_write_flag]{yyjson_write_flag()}}
}
