% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classified.R
\name{classified.default}
\alias{classified.default}
\title{Create Classified by Default}
\usage{
\method{classified}{default}(
  x = character(),
  levels,
  labels = levels,
  exclude = NA,
  ordered = is.ordered(x),
  nmax = NA,
  ...
)
}
\arguments{
\item{x}{see \code{\link{factor}}}

\item{levels}{see \code{\link{factor}}}

\item{labels}{see \code{\link{factor}}, must have same length as levels}

\item{exclude}{see \code{\link{factor}}}

\item{ordered}{see \code{\link{factor}}}

\item{nmax}{see \code{\link{factor}}}

\item{...}{ignored}
}
\value{
'classified' 'factor'
}
\description{
Creates a factor of subclass 'classified',
for which there are attribute-preserving methods.
In particular, classified has a codelist attribute
indicating the origin of its levels: it is
constructed from the codelist attribute of x
if available, or from 'levels' and 'labels'
by default. Unlike the case for \code{\link{factor}},
length of labels cannot be one (i.e., different from
length of levels).
}
\examples{
classified(1:3)
classified(1:3, levels = 4:6)
classified(1:3, levels = 1:3)
classified(1:3, labels = letters[1:3])
}
\seealso{
Other classified: 
\code{\link{[.classified}()},
\code{\link{[<-.classified}()},
\code{\link{[[.classified}()},
\code{\link{[[<-.classified}()},
\code{\link{c.classified}()},
\code{\link{classified.data.frame}()},
\code{\link{classified}()},
\code{\link{unclassified.classified}()},
\code{\link{unclassified.data.frame}()},
\code{\link{unclassified}()}
}
\concept{classified}
