% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module2_estimations.R
\name{estimate.3pl}
\alias{estimate.3pl}
\title{Estimation of People and Item Parameters}
\usage{
estimate.3pl(responses, ...)
}
\arguments{
\item{responses}{a data frame of responses}

\item{...}{other optional arguments}
}
\value{
a 3PL \code{irt.model} object with estimated people and item parameters
}
\description{
\code{estimate.3pl} estimates both people and item responses for given responses
}
\examples{
\dontrun{
data <- irt.model(model="3pl")$gen.data(2000, 50)
x <- estimate.3pl(data$responses, debug=TRUE)
cor(data$people$theta, people$theta)
plot(data$people$theta, people$theta, xlim=c(-4,4), ylim=c(-4,4), 
xlab="True", ylab="Est.", col=rgb(.8,.2,.2,.7))
abline(a=0, b=1, lty=2)
cor(data$items, items)
plot(data$items$a, items$a, xlim=c(0,2), ylim=c(0,2), 
xlab="True", ylab="Est.", col=rgb(.8,.2,.2,.7))
abline(a=0, b=1, lty=2)
plot(data$items$b, items$b, xlim=c(-3,3), ylim=c(-3,3), 
xlab="True", ylab="Est.", col=rgb(.8,.2,.2,.7))
abline(a=0, b=1, lty=2)
plot(data$items$c, items$c, xlim=c(0,.4), ylim=c(0,.4), 
xlab="True", ylab="Est.", col=rgb(.8,.2,.2,.7))
abline(a=0, b=1, lty=2)
}
}

