% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xtune.R
\name{xtune}
\alias{xtune}
\title{Tuning differential shrinkage parameters in penalized regression based on external information.}
\usage{
xtune(X, Y, Z = NULL, family = c("linear", "binary"), sigma.square = NULL,
  method = c("lasso", "ridge"), message = TRUE, control = list())
}
\arguments{
\item{X}{Numeric design matrix of explanatory variables (\eqn{n} observations in rows, \eqn{p} predictors in columns), without an intercept. \code{xtune} includes an intercept by default.}

\item{Y}{Outcome vector of dimension \eqn{n}. Quantitative for family="linear", or family="binary" for a 0/1 binary outcome variable.}

\item{Z}{Numeric information matrix about the predictors (\eqn{p} rows, each corresponding to a predictor in X; \eqn{q} columns of external information about the predictors, such as prior biological importance). If Z is the grouping of predictors, it is best if user codes it as a dummy variable (i.e. each column indicating whether predictors belong to a specific group)}

\item{family}{Response type. "linear" for continuous outcome, "binary" for 0/1 binary outcome.}

\item{sigma.square}{A user-supplied noise variance estimate. Typically, this is left unspecified, and the function automatically computes an estimated sigma square values using R package \code{selectiveinference}.}

\item{method}{The type of regularization applied in the model. method = 'lasso' for Lasso regression, method = 'ridge' for Ridge regression}

\item{message}{Generates diagnostic message in model fitting. Default is TRUE.}

\item{control}{Specifies \code{xtune} control object. See \code{\link{xtune.control}} for more details.}
}
\value{
An object with S3 class \code{xtune} containing:
\item{beta.est}{The fitted vector of coefficients.}
\item{penalty.vector}{The estimated penalty vector applied to each regression coefficient. Similar to the \code{penalty.factor} argument in \link{glmnet}.}
\item{lambda}{The estimated \eqn{\lambda} value. Note that the lambda value is calculated to reflect that the fact that penalty factors are internally rescaled to sum to nvars in \link{glmnet}. Similar to the \code{lambda} argument in \link{glmnet}.}
\item{n_iter}{Number of iterations used until convergence.}
\item{method}{Same as in argument above}
\item{sigma.square}{The estimated sigma square value using \code{\link{estimateVariance}}, if \code{sigma.square} is left unspecified.}
\item{family}{same as above}
\item{likelihood}{A vector containing the marginal likelihood value of the fitted model at each iteration.}
}
\description{
\code{xtune} uses an Empirical Bayes approach to integrate external information into penalized linear regression models. It fits models with differential amount of shrinkage for each regression coefficient based on external information.
}
\details{
\code{xtune} has two main usages:
\itemize{
\item The basic usage of it is to choose the tuning parameter \eqn{\lambda} in Lasso and Ridge regression using an
Empirical Bayes approach, as an alternative to the widely-used cross-validation. This is done by calling \code{xtune} without specifying external information matrix Z.

\item More importantly, if an external information Z about the predictors X is provided, \code{xtune} can allow differential shrinkage
parameters for regression coefficients in penalized regression models. The idea is that Z might be informative for the effect-size of regression coefficients, therefore we can guide the penalized regression model using Z.
}

Please note that the number of rows in Z should match with the number of columns in X. Since each column in Z is a feature about X. \href{https://github.com/ChubingZeng/xtune}{See here for more details on how to specify Z}.

A majorization-minimization procedure is employed to fit \code{xtune}.
}
\examples{
## use simulated example data
set.seed(9)
data(example)
X <- example$X
Y <- example$Y
Z <- example$Z

## Empirical Bayes tuning to estimate tuning parameter, as an alternative to cross-validation:
fit.eb <- xtune(X,Y)
fit.eb$lambda

### compare with tuning parameter choosen by cross-validation, using glmnet
\dontrun{
fit.cv <- cv.glmnet(X,Y,alpha = 1)
fit.cv$lambda.min
}
## Differential shrinkage based on external information Z:
fit.diff <- xtune(X,Y,Z)
fit.diff$penalty.vector

}
\seealso{
\link{predict.xtune}, as well as \link{glmnet}.
}
\author{
Chubing Zeng
}
