% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xtractogon.R
\name{xtractogon}
\alias{xtractogon}
\title{Extract environmental data in a polygon using ERDDAP.}
\usage{
xtractogon(dtype, xpos, ypos, tpos = NA, verbose = FALSE)
}
\arguments{
\item{dtype}{- number or string identifying the ERDDAP parameter to extract}

\item{xpos}{- array giving longitudes (in decimal
degrees East, either 0-360 or -180 to 180) of polygon}

\item{ypos}{-  array giving latitudes (in decimal
degrees N; -90 to 90)of polygon}

\item{tpos}{- 2-element array giving min and max time (specify both minimum
and maximum dates). For the last available time, use "last". Default NA.}

\item{verbose}{- logical for verbose download out, default FALSE}
}
\value{
structure with data and dimensions
\itemize{
  \item extract$data - the masked data array dimensions (lon,lat,time)
  \item extract$varname - the name of the parameter extracted
  \item extract$datasetname - ERDDAP dataset name
  \item extract$longitude - the longitudes on some scale as request
  \item extract$latitude - the latitudes always going south to north
  \item extract$time - the times of the extracts
  }
}
\description{
\code{xtractogon} uses the ERD ERDDAP data web service to extact
environmental data inside a polygon defined by vectors of
latitudes and longitudes
}
\section{Details}{

 xtractogon extracts the data from the smallest bounding box that contains
 the polygon, and then uses the function "point.in.polygon" from the "sp"
 package to mask out the areas outside of the polygon.
}

\examples{
tpos <- c("2014-09-01", "2014-10-01")
xpos <- mbnms$Longitude
ypos <- mbnms$Latitude
sanctchl <- xtractogon('erdVH3chlamday', xpos, ypos, tpos = tpos )
}
