% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xtracto_3D.R
\name{xtracto_3D}
\alias{xtracto_3D}
\title{Extract environmental data in a 3-D bounding box using ERDDAP.}
\usage{
xtracto_3D(xpos, ypos, tpos, dtype, verbose = FALSE)
}
\arguments{
\item{xpos}{- 2-element array giving min and max longitude (in decimal
degrees East, either 0-360 or -180 to 180)}

\item{ypos}{- 2-element array giving min and max latitude (in decimal
degrees N; -90 to 90)}

\item{tpos}{- 2-element array giving min and max time (specify both minimum
and maximum dates). For the last available time, use "last".}

\item{dtype}{- number or string identfying the ERDDAP parameter to extract}

\item{verbose}{- logical for verbose download output, default FALSE}
}
\value{
structure with data and dimensions:
\itemize{
  \item extract$data - the data array dimensioned (lon,lat,time)
  \item extract$varname - the name of the parameter extracted
  \item extract$datasetname - ERDDAP dataset name
  \item extract$longitude - the longitudes on some scale as request
  \item extract$latitude - the latitudes always going south to north
  \item extract$time - the times of the extracts
  }
}
\description{
\code{xtracto_3D} uses the ERD ERDDAP data web service to extact
environmental data in a given longitude, latitude and time bounding box
}
\examples{
xpos <- c(230, 232)
ypos <- c(40, 42)
tpos <- c('2006-05-05', '2006-05-06')
extract <- xtracto_3D(xpos, ypos, tpos, 150)
\donttest{
extract <- xtracto_3D(xpos, ypos, tpos, 150, verbose=TRUE)
extract <- xtracto_3D(xpos, ypos, tpos, 'erdMBsstd8day')
}
}

