% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_symmetric.R
\name{is_symmetric}
\alias{is_symmetric}
\title{Test symmetry of a matrix}
\usage{
is_symmetric(x, tol = 100 * .Machine$double.eps)
}
\arguments{
\item{x}{a matrix to be tested.}

\item{tol}{the tolerance for comparing the numbers.}
}
\value{
a logical value indicating whether or not the matrix is
symmetric
}
\description{
The function \code{\link[base]{isSymmetric}} tests for symmetry of a matrix but also
takes row and column names into account. This function is a toned-down
(and slightly faster) version that ignores row and column names.
Currently, the function only works for real matrices, not complex ones.
}
\examples{
x <- matrix(1:16,ncol = 4)
is_symmetric(x)

x <- x \%*\% t(x)
is_symmetric(x)

}
