% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xml2relational.r
\name{getCreateSQL}
\alias{getCreateSQL}
\title{Exporting the relational data model and data to a database}
\usage{
getCreateSQL(
  ldf,
  sql.style = "MySQL",
  tables = NULL,
  prefix.primary = "ID_",
  prefix.foreign = "FKID_",
  line.break = "\\n",
  datatype.func = NULL,
  one.statement = FALSE
)
}
\arguments{
\item{ldf}{A \strong{l}ist of \strong{d}ata\strong{f}rames created by
\code{\link{toRelational}()} (the data tables transformed from XML to a
relational schema).}

\item{sql.style}{The SQL flavor that the produced \code{CREATE} statements
will follow. The supported SQL styles are \code{"MySQL"},
\code{"TransactSQL"} and \code{"Oracle"}. You can add your own SQL flavor
by providing a dataframe with the required information instead of the name
of one of the predefined SQL flavors as value for \code{sql.style}. See the
Details section for more information on working with different SQL flavors.}

\item{tables}{A character vector with the names of the tables for whichs SQL
\code{CREATE} statements will be produced. If null (default) \code{CREATE}
statements will be produced for all tables in in the relational data model
of \code{ldf}.}

\item{prefix.primary}{The prefix that is used in the relational data model of
\code{ldf} to identify primary keys. \code{"ID_"} by default.}

\item{prefix.foreign}{The prefix that is used in the relational data model of
\code{ldf} to identify foreign keys. \code{"FKID_"} by default.}

\item{line.break}{Line break character that is added to the end of each
\code{CREATE} statement (apart from the semicolon that is added
automatically). Default is \code{"\n"}.}

\item{datatype.func}{A function that is used to determine the data type of
the table fields. The function must take the field/column from the data
table (basically the result of \code{SELCT field FROM table})
as its sole argument and return a character vector providing the data type.
If null (default), the built-in mechanism will be used to determine the
data type.}

\item{one.statement}{Determines whether all \code{CREATE} statements will be
returned as one piece of SQL code (\code{one.statement = TRUE}) or if each
\code{CREATE} statement will be stored in a separate element of the return
vector.}
}
\value{
A character vector with exactly one element (if argument
  \code{one.statement = TRUE}) or with one element per \code{CREATE}
  statement.
}
\description{
Produces ready-to-run SQL \code{INSERT} statements to import the
  data transformed with \code{\link{toRelational}()} into a SQL database.
}
\details{
If you want to produce SQL \code{CREATE} statements that follow a
  different SQL dialect than one of the built-in SQL flavors (i.e. MySQL,
  TransactSQL and Oracle) you can provide the necessary information to
  \code{getCreateSQL()} via the \code{sql.style} argument. In this case the
  \code{sql.style} argument needs to be a dataframe with the folling fields:
  \tabular{llll}{ Column \tab Type \tab Description \tab Example \cr
  \code{Style} \tab \code{character} \tab Name of the SQL flavor. \tab
  \code{"MySQL"}  \cr \code{NormalField} \tab \code{character} \tab Template
  string for a normal, nullable field. \tab \code{"\%FIELDNAME\% \%DATATYPE\%"}
  \cr \code{NormalFieldNotNull} \tab \code{character} \tab Template string
  for non-nullable field. \tab \code{"\%FIELDNAME\% \%DATATYPE\% NOT NULL"} \cr
  \code{PrimaryKey} \tab \code{character} \tab Template string for the
  definition of a primary key. \tab \code{"PRIMARY KEY (\%FIELDNAME\%)"} \cr
  \code{ForeignKey} \tab \code{character} \tab Template string for the
  definition of a foreign key. \code{"FOREIGN KEY (\%FIELDNAME\%) REFERENCES
  \%REFTABLE\%(\%REFPRIMARYKEY\%)"}  \cr \code{PrimaryKeyDefSeparate} \tab
  \code{logical} \tab Indicates if primary key needs additional definition
  like a any other field.  \tab \code{TRUE}  \cr \code{ForeignKeyDefSeparate}
  \tab \code{logical} \tab Indicates if foreign key needs additional
  definition like a any other field. \tab \code{TRUE} \cr \code{Int} \tab
  \tab \code{character} \tab Name of integer data type. \code{"INT"}  \cr
  \code{Int.MaxSize} \tab \code{numeric} \tab Size limit of integer data
  type.  \tab \code{4294967295}  \cr \code{BigInt} \tab \code{character} \tab
  Name of data type for integers larger than the size limit of the normal
  integer data type. \tab \code{"BIGINT"} \cr \code{Decimal} \tab
  \code{character} \tab Name of data type for floating point numbers. \tab
  \code{"DECIMAL"}  \cr \code{VarChar} \tab \code{character} \tab Name of
  data type for variable-size character fields. \tab \code{"VARCHAR"}  \cr
  \code{VarChar.MaxSize} \tab \code{numeric} \tab Size limit of variable-size
  character data type.\tab \code{65535} \cr \code{Text} \tab \code{character}
  \tab Name of data type for string data larger than the size limit of the
  variable-size character data type. \tab \code{"TEXT"} \cr \cr \code{Date}
  \tab \code{character} \tab Name of data type date data. \tab \code{"DATE"}
  \cr \code{Time} \tab \code{character} \tab Name of data type time data \tab
  \code{"TIME"} \cr \code{Date} \tab \code{character} \tab Name of data
  type for combined date and time data. \tab \code{"TIMESTAMP"}  \cr  }

  In the template strings you can use the following placeholders, as you also
  see from the MySQL example in the table: \enumerate{ \item
  \code{\%FIELDNAME\%}: Name of the field to be defined. \item
  \code{\%DATATYPE\%}: Datatype of the field to be defined. \item
  \code{\%REFTABLE\%}: Table referenced by a foreign key. \item
  \code{\%REFPRIMARYKEY\%}: Name of the primary key field of the table
  referenced by a foreign key. } When you use your own defintion of an SQL
  flavor, then \code{sql.style} must be a one-row dataframe providing the
  fields described in the table above.

  You can use the \code{datatype.func} argument to provide your own function
  to determine how the data type of a field is derived from the values in
  that field. In this case, the values of the columns \code{Int},
  \code{Int.MaxSize}, \code{VarChar}, \code{VarChar.MaxSize}, \code{Decimal}
  and \code{Text} in the \code{sql.style} dataframe are ignored. They are
  used by the built-in mechanism to determine data types. Providing your own
  function allows you to determine data types in a more differentiated way,
  if you like. The function that is provided needs to take a vectors of
  values as its argument and needs to provide the SQL data type of these
  values as a one-element character vector.
}
\examples{
# Find path to custmers.xml example file in package directory
path <- system.file("", "customers.xml", package = "xml2relational")
db <- toRelational(path)

sql.code <- getCreateSQL(db, "TransactSQL", "address")

}
\seealso{
Other xml2relational: 
\code{\link{getInsertSQL}()},
\code{\link{savetofiles}()},
\code{\link{toRelational}()}
}
\concept{xml2relational}
