% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_workbook.R
\name{load_workbook}
\alias{load_workbook}
\title{load_workbook}
\usage{
load_workbook(
  filename,
  read_only = FALSE,
  keep_vba = FALSE,
  data_only = FALSE,
  keep_links = TRUE,
  rich_text = FALSE,
  ...
)
}
\arguments{
\item{filename}{filename string or a file-like object open in binary mode c.f., :class:`zipfile.ZipFile` :param read_only: optimised for reading, content cannot be edited}

\item{read_only}{read_only bool}

\item{keep_vba}{keep_vba preserve vba content (this does NOT mean you can use it)}

\item{data_only}{data_only bool}

\item{keep_links}{keep_links whether links to external workbooks should be preserved. The default is TRUE}

\item{rich_text}{rich_text bool :rtype: :class:`openpyxl.workbook.Workbook` .. note:: When using lazy load, all worksheets will be :class:`openpyxl.worksheet.iter_worksheet.IterableWorksheet` and the returned workbook will be read-only.}

\item{...}{Additional arguments, i.e. kwargs.}
}
\value{
An openpyxl Python object.
}
\description{
Open the given filename and return the workbook

\url{https://openpyxl.readthedocs.io/en/stable/api/openpyxl.reader.excel.html}
}
\examples{
\dontrun{
tmp <- write_xlsx(list(mysheet = iris))
load_workbook(filename = tmp)
}
}
