% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-structure.R
\name{strict_list}
\alias{strict_list}
\alias{$.strict_list}
\alias{print.strict_list}
\title{Strict lists}
\usage{
strict_list(...)

\method{$}{strict_list}(x, name)

\method{print}{strict_list}(x, ...)
}
\arguments{
\item{...}{Objects (list elements), possibly named. Ignored in the
\code{print()} method.}

\item{x}{A strict list.}

\item{name}{The name (a character string) of the list element.}
}
\description{
A strict list is essentially a normal \code{\link{list}()} but it does not
allow partial matching with \code{$}.
}
\details{
To me, partial matching is often more annoying and surprising than
convenient. It can lead to bugs that are very hard to discover, and I have
been bitten for many times. When I write \code{x$name}, I always mean
precisely \code{name}. You should use a modern code editor to autocomplate
the \code{name} if it is too long to type, instead of using a partial name.
}
\examples{
library(xfun)
(z = strict_list(aaa = "I am aaa", b = 1:5))
z$a  # NULL!
z$aaa  # I am aaa
z$b
z$c = "create a new element"

z2 = unclass(z)  # a normal list
z2$a  # partial matching
}
