% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cooling.R
\name{LogarithmicMultiplicativeCooling}
\alias{LogarithmicMultiplicativeCooling}
\title{Logarithmic multiplicative cooling.}
\usage{
LogarithmicMultiplicativeCooling(k, lF)
}
\arguments{
\item{k}{Number of steps to discount.}

\item{lF}{Local configuration.}
}
\value{
Temperature at time k.

     Aarts, E., and Korst, J. (1989):
     Simulated Annealing and Boltzmann Machines.
     A Stochastic Approach to Combinatorial Optimization and
     Neural Computing.
     John Wiley & Sons, Chichester.
     (ISBN:0-471-92146-7)
}
\description{
This schedule decreases by the inverse proportion of the
             natural logarithm 
             of \code{k}. \code{lF$Alpha()} should be larger than 1.
}
\details{
Temperature is updated at the end of each generation
         in the main loop of the genetic algorithm.
         \code{lF$Temp0()} is the starting temperature.
         \code{lF$Alpha()} is a scaling factor.
}
\examples{
parm<-function(x){function() {return(x)}}
lF<-list(Temp0=parm(100), Alpha=parm(1.01))
LogarithmicMultiplicativeCooling(0, lF)
LogarithmicMultiplicativeCooling(2, lF)
}
\seealso{
Other Cooling: 
\code{\link{ExponentialAdditiveCooling}()},
\code{\link{ExponentialMultiplicativeCooling}()},
\code{\link{PowerAdditiveCooling}()},
\code{\link{PowerMultiplicativeCooling}()},
\code{\link{TrigonometricAdditiveCooling}()}
}
\concept{Cooling}
