% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configuration.R
\name{xegaConfiguration}
\alias{xegaConfiguration}
\title{Remembers R command command with which algorithm has been called.}
\usage{
xegaConfiguration(GAname, penv, grammar, env)
}
\arguments{
\item{GAname}{Name of genetic algorithm's main function.
(Currently: "Run").}

\item{penv}{The expression for the problem environment \code{penv}.
Use: \code{substitute(penv)}.}

\item{grammar}{The grammar \code{grammar}.
Use: \code{substitute(grammar)}.}

\item{env}{Environment with variable value bindings.
Use: \code{environment()}.}
}
\value{
A named list with the following elements:
  \itemize{
  \item \code{$GAconf}: 
                 A text string with the call of the genetic algorithm
                 (the function we want to capture the call).
  \item \code{$GAenv}:   The environment with the arguments bound to the 
                 values when the genetic algorithm was called.
  }
}
\description{
\code{xegaConfiguration()} returns the command with which
             the genetic algorithm has been called. 
             For replicating computational experiments with 
             genetic algorithms.
}
\section{Warning}{

   \itemize{
   \item
   $GAenv is correct only for simple arguments (strings or numbers) 
   not for complex objects like problem environments.
   \item 
   \code{future.apply::future_lapply()} is configured by a plan 
   statement which must be issued before calling the genetic 
   algorithm. At the moment, the plan chosen is not remembered.
   }
}

\examples{
GA<-function(pe, grammar=NULL, nope=1.5, sle="test", ok=TRUE) 
{xegaConfiguration("GA", substitute(pe), substitute(grammar), environment())}
Para<-5
GA(Para)
Cube<-7
GA(Cube, 2, 3, 4)

}
\seealso{
Other Configuration: 
\code{\link{AcceptFactory}()},
\code{\link{ApplyFactory}()},
\code{\link{CoolingFactory}()},
\code{\link{CrossRateFactory}()},
\code{\link{MutationRateFactory}()}
}
\concept{Configuration}
