% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractCCC.R
\name{extractCCC}
\alias{extractCCC}
\title{Extract chromatic coefficients and their statistics}
\usage{
extractCCC(path, m)
}
\arguments{
\item{path}{path to the JPEG file}

\item{m}{mask binary matrix (1 for selected)}
}
\value{
The function returns statistical metrics for each color channel. The function returns NULL, if dimensions do not agree.
}
\description{
This function apply a mask matrix to a jpeg image and extract statstical metrics for each chromatic coefficients on R, G and B.
}
\examples{

m <- tiff::readTIFF(system.file(package = 'xROI', 'dukehw-mask.tif'))
jpgFile <- system.file(package = 'xROI', 'dukehw.jpg')
cc <- extractCCC(jpgFile, m)
}
\keyword{bcc}
\keyword{chromatic}
\keyword{coefficients}
\keyword{exract}
\keyword{gcc}
\keyword{rcc}
