% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addMask.R
\name{addMask}
\alias{addMask}
\title{Plot or add a mask}
\usage{
addMask(mask, add = TRUE, col = "black")
}
\arguments{
\item{mask}{binary or logical matrix, describing the mask (1 for selected pixels, 0 for not selected pixels)}

\item{add}{whether to add the mask to and existing plot}

\item{col}{color value of the plotted mask}
}
\description{
This function plot or add a mask raster on the graphics.
}
\examples{

#read a mask file in TIFF format
m <- tiff::readTIFF(system.file(package = 'xROI', 'dukehw-mask.tif'))
str(m)

#plot the mask in black color
addMask(m, add = FALSE)

#add the same mask in red color to the existing plot
addMask(m, add = TRUE, col = 'red')

}
\keyword{mask}
\keyword{plot}
\keyword{raster}
