% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{xQTLquery_eqtl}
\alias{xQTLquery_eqtl}
\title{query multi-tissue eQTL metasoft results}
\usage{
xQTLquery_eqtl(
  variantName = "",
  gene = "",
  variantType = "auto",
  geneType = "auto",
  tissueSiteDetail = "",
  recordPerChunk = 100
)
}
\arguments{
\item{variantName}{(character) name of variant, dbsnp ID and variant id is supported, eg. "rs138420351" and "chr17_7796745_C_T_b38".}

\item{gene}{(character) gene symbol or gencode id (versioned or unversioned are both supported). Can not be null.}

\item{variantType}{(character) options: "auto", "snpId" or "variantId". Default: "auto".}

\item{geneType}{(character) options: "auto","geneSymbol" or "gencodeId". Default: "auto".}

\item{tissueSiteDetail}{(character) details of tissues in GTEx can be listed using \code{tissueSiteDetailGTExv8} or \code{tissueSiteDetailGTExv7}}

\item{recordPerChunk}{(integer) number of records fetched per request (default: 100).}
}
\value{
A data.table object.
}
\description{
can be quried with a gene/variant-gene pair.
}
\examples{
\donttest{
# Query with a gene symbol:
eqtlInfo <- xQTLquery_eqtl(gene="TP53")

# Query with unversioned gencode ID:
eqtl_v8 <- xQTLquery_eqtl(gene="ENSG00000141510")

# In a specific tissue:
xQTLquery_eqtl(gene="ENSG00000141510", geneType="gencodeId",  tissueSiteDetail="Thyroid" )

# Query with a variant-gene pair:
xQTLquery_eqtl(variantName="rs1641513",gene="TP53")
xQTLquery_eqtl(variantName="chr1_1667948_A_G_b38", gene="SLC35E2B",
                  tissueSiteDetail="Kidney - Cortex")
}
}
