% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/name.clean.R
\name{name.clean}
\alias{name.clean}
\title{Name cleaning and matching function.}
\usage{
name.clean(voters)
}
\arguments{
\item{voters}{An object of class \code{data.frame}. Must contain a field 
named 'surname'.}
}
\value{
Output will be an object of class \code{data.frame}. It will 
 consist of the original user-input data with additional columns that 
 specify the part of the name matched with Census data (\code{\var{surname.match}}), 
 and the probabilities Pr(Race | Surname) for each racial group 
 (\code{\var{p_whi}} for Whites, \code{\var{p_bla}} for Blacks, 
 \code{\var{p_his}} for Hispanics/Latinos, \code{\var{p_asi}} for Asians, and 
 \code{\var{p_oth}} for Others).
}
\description{
\code{name.clean} cleans surnames in user-input dataset and merges in racial 
 distributions from the Census Surname List and Census Spanish Surname List.
}
\details{
This function allows users to match surnames in their dataset with the U.S. 
 Census 2000 Surname List to obtain Pr(Race | Surname) for each of the 
 five major racial groups. The function matches user-input surnames with 
 Census surnames as follows (each step only applies to surnames not matched 
 in previous steps): 
 1) match raw surnames with Census data; 
 2) remove any spaces and search again; 
 3) split apart double-barreled surnames into two names and match on first; 
 4) split apart double-barreled surnames into two names and match on second; 
 5) for any remaining names, impute probabilities from overall U.S. population.
 Note: Any name appearing only on the Spanish Surname List is assigned a 
 probability of 1 for Hispanics/Latinos and 0 for all other racial groups.
}
\examples{
data(voters)
name.clean(voters)

}

