% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_dot_fn.R
\name{as_dot_fn}
\alias{as_dot_fn}
\title{Convert an unevaluted pipeline into a function.}
\usage{
as_dot_fn(pipeline, env = parent.frame())
}
\arguments{
\item{pipeline}{a un-evaluated wrapr pipeline.}

\item{env}{envirnonment to work in.}
}
\value{
single function with signature (., env = parent.frame())
}
\description{
Convert an unevaluted pipeline into a function of "."
}
\details{
Note: writes "." into env.
}
\examples{

f <- as_dot_fn(sin(.) \%.>\% cos(.))
f(1:3)

g <- as_dot_fn(. \%.>\% sin(.) \%.>\% cos(.))
g(1:3)

}
