% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linModelSelect.R
\name{linModelSelect}
\alias{linModelSelect}
\title{Selecte best levels and plot linear regression model}
\usage{
linModelSelect(
  protNa,
  dat,
  expect,
  logExpect = FALSE,
  startLev = NULL,
  liNa = c(raw = "raw", annot = "annot", datImp = "datImp"),
  plotGraph = TRUE,
  yLab = NULL,
  cexLeg = 0.95,
  cexSub = 0.85,
  cexYAxis = 0.9,
  cexXAxis = 0.85,
  cexLab = 1.1,
  silent = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{protNa}{(character, length=1) rowname for line to be extracted from \code{dat}}

\item{dat}{(matrix, list or MArrayLM-object from limma) main input of which columns should get re-ordered, may be output from \code{\link{moderTestXgrp}} or \code{\link{moderTest2grp}}.}

\item{expect}{(numeric of character) the expected levels; if character, constant unit-characters will be stripped away to extact the numeric content}

\item{logExpect}{(logical) toggle to \code{TRUE} if the main data are logarithmic}

\item{startLev}{(integer) specify all starting levels to test for omitting here}

\item{liNa}{(character) in case \code{cat} is list or MArrayLM-type object, the list-elements with these names will be used as $raw (for indicating initial \code{NA}-values,
$datImp (the main quantitation data to use) and $annot for displaying the corresponding value from the "Accession"-column.}

\item{plotGraph}{(logical) display figure}

\item{yLab}{(character) custom y-axis label}

\item{cexLeg}{(character) size of text in legend}

\item{cexSub}{(character) size of subtitle (giving regression details of best linear model)}

\item{cexYAxis}{(character) size of text for y-axis labels}

\item{cexXAxis}{(character) size of text for x-axis labels}

\item{cexLab}{(character)  text in x & y axis legend (will be passed to \code{cex.lab} in \code{plot()})}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
list with $coef (coefficients), $name (as/from input \code{protNa}), $startLev the best starting level)
}
\description{
The aim of this function is to select the data suiting est to a linear regression model. 
In real world measurements one may be confronted to the case of very low level analytes below the detection limit (LOD) and resulting read-outs fluctuate around around a common baseline (instead of \code{NA}). 
With such data it may be preferable to omit the read-outs for the lowest concentrations/levels of analytes if they are spread around a base-line value.
This function allows trying to omit all starting levels designed in \code{startLev}, then the resulting p-values for the linear regression slopes will be checked and the best p-value chosen. 
The input may also be a MArrayLM-type object from package \href{https://bioconductor.org/packages/release/bioc/html/limma.html}{limma} or from \code{\link{moderTestXgrp}} or \code{\link{moderTest2grp}}.
In the graphical representation all points assocoated to levels omitted are shown in light green.
For the graphical display additional information can be used : If the  \code{dat} is list or MArrayLM-type object, the list-elements $raw (according to argument \code{liNa} will be used to display points initially given as NA ad imputed lateron in grey.
Logarithmic (ie log-linear) data can be treated by settting argument \code{logExpect=TRUE}. Then the levels will be taken as exponent of 2 for the regression, while the original values will be displayed in the figure.
}
\examples{
## Construct data
li1 <- rep(c(4,3,3:6),each=3) + round(runif(18)/5,2)
names(li1) <- paste0(rep(letters[1:5], each=3), rep(1:3,6))
li2 <- rep(c(6,3:7), each=3) + round(runif(18)/5, 2)
dat2 <- rbind(P1=li1, P2=li2)
exp2 <- rep(c(11:16), each=3)
exp4 <- rep(c(3,10,30,100,300,1000), each=3)

## Check & plot for linear model 
linModelSelect("P1", dat2, expect=exp2)
linModelSelect("P2", dat2, expect=exp2)

## Log-Linear data
dat4 <- rbind(P1=2^li1, P2=2^li2)
linModelSelect("P1", dat4, expect=exp2, log=TRUE)

linModelSelect("P1", dat4, expect=log2(exp2), log=FALSE)

linModelSelect("P1", dat4, expect=exp4, log=TRUE)
}
\seealso{
\code{\link{moderTestXgrp}} for single comparisons, \code{\link[base]{order}}
}
