% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anlz_prd.R
\name{anlz_prd}
\alias{anlz_prd}
\title{Get predicted data from fitted GAMs across period of observation}
\usage{
anlz_prd(mod, annual = FALSE)
}
\arguments{
\item{mod}{input model object as returned by \code{\link{anlz_gam}}}

\item{annual}{logical indicating if predictions only for the \code{cont_year} smoother are returned}
}
\value{
a \code{data.frame} with predictions
}
\description{
Get predicted data from fitted GAMs across period of observation
}
\examples{
library(dplyr)

# data to model
tomod <- rawdat \%>\%
  filter(station \%in\% 34) \%>\%
  filter(param \%in\% 'chl') \%>\% 
  filter(yr > 2015)
  
mod <- anlz_gam(tomod, trans = 'log10')
anlz_prd(mod)
}
\concept{analyze}
