% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_period_scatter.R
\name{create_period_scatter}
\alias{create_period_scatter}
\title{Period comparison scatter plot for any two metrics}
\usage{
create_period_scatter(
  data,
  hrvar = "Organization",
  metric_x = "Multitasking_meeting_hours",
  metric_y = "Meeting_hours",
  before_start = min(as.Date(data$Date, "\%m/\%d/\%Y")),
  before_end,
  after_start = as.Date(before_end) + 1,
  after_end = max(as.Date(data$Date, "\%m/\%d/\%Y")),
  before_label = "Period 1",
  after_label = "Period 2",
  mingroup = 5,
  return = "plot"
)
}
\arguments{
\item{data}{A Standard Person Query dataset in the form of a data frame.}

\item{hrvar}{HR Variable by which to split metrics. Accepts a character vector,
defaults to "Organization" but accepts any character vector, e.g. "LevelDesignation"}

\item{metric_x}{Character string containing the name of the metric,
e.g. "Collaboration_hours"}

\item{metric_y}{Character string containing the name of the metric,
e.g. "Collaboration_hours"}

\item{before_start}{Start date of "before" time period in YYYY-MM-DD}

\item{before_end}{End date of "before" time period in YYYY-MM-DD}

\item{after_start}{Start date of "after" time period in YYYY-MM-DD}

\item{after_end}{End date of "after" time period in YYYY-MM-DD}

\item{before_label}{String to specify a label for the "before" period. Defaults to "Period 1".}

\item{after_label}{String to specify a label for the "after" period. Defaults to "Period 2".}

\item{mingroup}{Numeric value setting the privacy threshold / minimum group size.
Defaults to 5.}

\item{return}{Character vector specifying what to return, defaults to "plot".
Valid inputs are "plot" and "table".}
}
\value{
Returns a 'ggplot' object showing two scatter plots side by side representing
the two periods.
}
\description{
Returns two side-by-side scatter plots representing two selected metrics,
using colour to map an HR attribute and size to represent number of employees.
Returns a faceted scatter plot by default, with additional options
to return a summary table.
}
\details{
This is a general purpose function that powers all the functions
in the package that produce faceted scatter plots.
}
\examples{
# Return plot
create_period_scatter(sq_data,
                      hrvar = "LevelDesignation",
                      before_start = "2019-12-15",
                      before_end = "2019-12-29",
                      after_start = "2020-01-05",
                      after_end = "2020-01-26")

# Return a summary table
create_period_scatter(sq_data, before_end = "2019-12-31", return = "table")


}
\seealso{
Other Visualization: 
\code{\link{afterhours_dist}()},
\code{\link{afterhours_fizz}()},
\code{\link{afterhours_line}()},
\code{\link{afterhours_rank}()},
\code{\link{afterhours_summary}()},
\code{\link{afterhours_trend}()},
\code{\link{collaboration_area}()},
\code{\link{collaboration_dist}()},
\code{\link{collaboration_fizz}()},
\code{\link{collaboration_line}()},
\code{\link{collaboration_rank}()},
\code{\link{collaboration_sum}()},
\code{\link{collaboration_trend}()},
\code{\link{create_bar}()},
\code{\link{create_bar_asis}()},
\code{\link{create_boxplot}()},
\code{\link{create_bubble}()},
\code{\link{create_dist}()},
\code{\link{create_fizz}()},
\code{\link{create_inc}()},
\code{\link{create_line}()},
\code{\link{create_line_asis}()},
\code{\link{create_rank}()},
\code{\link{create_sankey}()},
\code{\link{create_scatter}()},
\code{\link{create_stacked}()},
\code{\link{create_tracking}()},
\code{\link{create_trend}()},
\code{\link{email_dist}()},
\code{\link{email_fizz}()},
\code{\link{email_line}()},
\code{\link{email_rank}()},
\code{\link{email_summary}()},
\code{\link{email_trend}()},
\code{\link{external_dist}()},
\code{\link{external_fizz}()},
\code{\link{external_line}()},
\code{\link{external_network_plot}()},
\code{\link{external_rank}()},
\code{\link{external_sum}()},
\code{\link{hr_trend}()},
\code{\link{hrvar_count}()},
\code{\link{hrvar_trend}()},
\code{\link{internal_network_plot}()},
\code{\link{keymetrics_scan}()},
\code{\link{meeting_dist}()},
\code{\link{meeting_fizz}()},
\code{\link{meeting_line}()},
\code{\link{meeting_quality}()},
\code{\link{meeting_rank}()},
\code{\link{meeting_summary}()},
\code{\link{meeting_trend}()},
\code{\link{meetingtype_dist}()},
\code{\link{meetingtype_dist_ca}()},
\code{\link{meetingtype_dist_mt}()},
\code{\link{meetingtype_summary}()},
\code{\link{mgrcoatt_dist}()},
\code{\link{mgrrel_matrix}()},
\code{\link{one2one_dist}()},
\code{\link{one2one_fizz}()},
\code{\link{one2one_freq}()},
\code{\link{one2one_line}()},
\code{\link{one2one_rank}()},
\code{\link{one2one_sum}()},
\code{\link{one2one_trend}()},
\code{\link{period_change}()},
\code{\link{workloads_dist}()},
\code{\link{workloads_fizz}()},
\code{\link{workloads_line}()},
\code{\link{workloads_rank}()},
\code{\link{workloads_summary}()},
\code{\link{workloads_trend}()},
\code{\link{workpatterns_area}()},
\code{\link{workpatterns_rank}()}

Other Flexible: 
\code{\link{create_bar}()},
\code{\link{create_bar_asis}()},
\code{\link{create_boxplot}()},
\code{\link{create_bubble}()},
\code{\link{create_density}()},
\code{\link{create_dist}()},
\code{\link{create_fizz}()},
\code{\link{create_hist}()},
\code{\link{create_inc}()},
\code{\link{create_line}()},
\code{\link{create_line_asis}()},
\code{\link{create_rank}()},
\code{\link{create_sankey}()},
\code{\link{create_scatter}()},
\code{\link{create_stacked}()},
\code{\link{create_tracking}()},
\code{\link{create_trend}()},
\code{\link{period_change}()}

Other Time-series: 
\code{\link{IV_by_period}()},
\code{\link{create_line}()},
\code{\link{create_line_asis}()},
\code{\link{create_trend}()},
\code{\link{period_change}()}
}
\concept{Flexible}
\concept{Time-series}
\concept{Visualization}
