% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wm_externalid.R
\name{wm_external}
\alias{wm_external}
\title{Get an external ID via an AphiaID}
\usage{
wm_external(id, type = "tsn", ...)
}
\arguments{
\item{id}{(numeric/integer) an AphiaID. required.}

\item{type}{(character) the type of external id. one of: tsn, bold,
dyntaxa, eol, fishbase, iucn, lsid, ncbi, gisd. default: tsn}

\item{...}{named curl options. see \code{\link[curl]{curl_options}}}
}
\description{
Get an external ID via an AphiaID
}
\examples{
# by default, get a TSN (an ITIS code)
wm_external(id = 1080)

# BOLD code
wm_external(id = 278468, type = "bold")

# NCBI code
wm_external(id = 278468, type = "ncbi")

# fishbase code
wm_external(id = 278468, type = "fishbase")

library(crul)
wm_external(id = 105706, verbose = TRUE)
}

