##' Access surface meteorological data from the NOAA Integrated Surface Database
##' from around the world
##'
##' This package contains functions to import surface meteorolgical
##' data from over 30,000 sites around the world. These data are
##' curated by NOAA as part of the Integrated Surface Database (ISD).
##'
##' If you access these data using the \code{worldmet} package please
##' give full acknowledgement to NOAA ISD. Users should also take a
##' note of the usage restrictions.
##'
##' These data work well with the \code{openair} package that has been
##' developed to analyse air pollution data.
##'
##' @author David Carslaw
##'
##' @references For general information of the ISD see
##' \url{https://www.ncei.noaa.gov/products/land-based-station/integrated-surface-database} and the map here
##' \url{https://gis.ncdc.noaa.gov/maps/ncei}.
##' @keywords methods
##'
##' @name worldmet
##' @docType package
##'
##' @seealso See \url{https://github.com/davidcarslaw/openair} for
##' information on the related \code{openair} package.
##'
##'
NULL
