% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_season_player_stats.R
\name{fb_player_season_stats}
\alias{fb_player_season_stats}
\title{Get fbref Player Season Statistics}
\usage{
fb_player_season_stats(player_url, stat_type, time_pause = 3)
}
\arguments{
\item{player_url}{the URL(s) of the player(s) (can come from fb_player_urls())}

\item{stat_type}{the type of statistic required}

\item{time_pause}{the wait time (in seconds) between page loads

The statistic type options (stat_type) include:

\emph{"standard"}, \emph{"shooting"}, \emph{"passing"},
\emph{"passing_types"}, \emph{"gca"}, \emph{"defense"}, \emph{"possession"}
\emph{"playing_time"}, \emph{"misc"}, \emph{"keeper"}, \emph{"keeper_adv"}}
}
\value{
returns a dataframe of a player's historical season stats
}
\description{
Returns the historical season stats for a selected player(s) and stat type
}
\examples{
\dontrun{
try({
fb_player_season_stats("https://fbref.com/en/players/3bb7b8b4/Ederson",
                       stat_type = 'standard')

multiple_playing_time <- fb_player_season_stats(
 player_url = c("https://fbref.com/en/players/d70ce98e/Lionel-Messi",
           "https://fbref.com/en/players/dea698d9/Cristiano-Ronaldo"),
 stat_type = "playing_time")
})
}
}
