% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workspace.R
\name{workspace_copy}
\alias{workspace_copy}
\title{Clone a Workspace}
\usage{
workspace_copy(x)
}
\arguments{
\item{x}{the workspace to copy}
}
\value{
New workspace copy
}
\description{
Clone/Copy a workspace. This function is necessary as
assignment would not change internal directory that is certainly
defined in a temporary directory that will be removed when
R session will be stopped.
}
\examples{
library(workspace)
dir_tmp <- tempfile(pattern = "ws")
z <- new_workspace(dir = dir_tmp)
z <- store_dataset(x = z, dataset = iris, name = "iris_dataset")
z <- store_dataset(x = z, dataset = mtcars, name = "mtcars")
json_str <- paste0("{\"first_name\": \"John\",\"last_name\": \"Smith\",\"is_alive\": true,",
"\"age\": 27, \"address\": { \"street_address\": \"21 2nd Street\",",
"\"city\": \"New York\",\"state\": \"NY\",\"postal_code\": \"10021-3100\"",
"}}")
z <- store_json(
  x = z,
  json_str = json_str,
  filename = "example.json",
  timestamp = "2023-11-12 11:37:41",
  subdir = "blah"
)
z <- store_rds(
  x = z,
  obj = mtcars,
  filename = "obj.rds",
  timestamp = "2023-11-12 11:37:41",
  subdir = "r-object"
)

new_z <- workspace_copy(z)
}
\seealso{
\link{workspace} for package documentation

Other functions to manage workspaces: 
\code{\link{new_workspace}()},
\code{\link{pack_workspace}()},
\code{\link{unpack_workspace}()},
\code{\link{workspace_bind}()}
}
\concept{functions to manage workspaces}
