/*
 * Decompiled with CFR 0.152.
 */
package com.nexagis.jawbone;

import com.nexagis.jawbone.IndexTerm;
import com.nexagis.jawbone.LineSplitter;
import com.nexagis.jawbone.PartOfSpeech;
import com.nexagis.jawbone.Synset;
import com.nexagis.jawbone.Utility;
import com.nexagis.jawbone.filter.ExactMatchFilter;
import com.nexagis.jawbone.filter.TermFilter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ParseIndexFile {
    private ParseIndexFile() {
    }

    private static void writeErr(String string) {
        System.err.println(string);
    }

    private static IndexTerm process(String string) {
        int n;
        if (string == null || string.length() < 1) {
            return null;
        }
        IndexTerm indexTerm = new IndexTerm();
        LineSplitter lineSplitter = new LineSplitter(string, ' ');
        indexTerm.setLemma(lineSplitter.nextToken());
        indexTerm.setPartOfSpeech(lineSplitter.nextToken().charAt(0));
        int n2 = Integer.parseInt(lineSplitter.nextToken());
        indexTerm.setSynsetCount(n2);
        int n3 = Integer.parseInt(lineSplitter.nextToken());
        indexTerm.setPointerCount(n3);
        for (n = 0; n < n3; ++n) {
            String string2 = lineSplitter.nextToken();
            indexTerm.setPointerSymbol(n, string2);
        }
        lineSplitter.nextToken();
        int n4 = Integer.parseInt(lineSplitter.nextToken());
        indexTerm.setTagSenseCount(n4);
        for (n = 0; n < n2; ++n) {
            int n5 = Integer.parseInt(lineSplitter.nextToken());
            indexTerm.setSynsetOffset(n, n5);
        }
        return indexTerm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static List<IndexTerm> parseFile(PartOfSpeech partOfSpeech, int n, TermFilter termFilter) {
        if (partOfSpeech == null) {
            throw new RuntimeException("The part of speech is null");
        }
        if (n == 0) {
            return new ArrayList<IndexTerm>(1);
        }
        String string = Utility.getFilename(partOfSpeech, true);
        if (string == null || string.length() < 1) {
            throw new RuntimeException("The input file was not specified");
        }
        File file = new File(string);
        boolean bl = file.exists();
        if (!bl) {
            throw new RuntimeException("The data file does not exist");
        }
        if (!file.isFile()) {
            throw new RuntimeException("The data file is not a file");
        }
        ArrayList<IndexTerm> arrayList = null;
        arrayList = n > 0 ? new ArrayList<IndexTerm>(n) : new ArrayList(500);
        BufferedReader bufferedReader = null;
        try {
            String string2;
            bufferedReader = new BufferedReader(new FileReader(file));
            while ((string2 = bufferedReader.readLine()) != null) {
                IndexTerm indexTerm;
                if (string2.length() < 1 || string2.charAt(0) == ' ' || (indexTerm = ParseIndexFile.process(string2)) == null || termFilter != null && !termFilter.accept(indexTerm.getLemma())) continue;
                arrayList.add(indexTerm);
                if (n <= 0 || arrayList.size() < n) continue;
                break;
            }
            bufferedReader.close();
            bufferedReader = null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            ParseIndexFile.writeErr("File Not Found: " + fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            ParseIndexFile.writeErr("Exception reading: " + iOException.getMessage());
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                    bufferedReader = null;
                }
                catch (Exception exception) {
                    bufferedReader = null;
                }
            }
        }
        return arrayList;
    }

    public static int getSenseNumber(String string, PartOfSpeech partOfSpeech, long l) {
        int n = 0;
        List<IndexTerm> list = ParseIndexFile.parseFile(partOfSpeech, 1, new ExactMatchFilter(string, false));
        if (list == null || list.size() < 1) {
            return n;
        }
        Synset[] synsetArray = list.get(0).getSynsets();
        for (int i = 0; i < synsetArray.length; ++i) {
            if (synsetArray[i].getSynsetOffset() != l) continue;
            n = i + 1;
            break;
        }
        return n;
    }
}

